/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.filters.Filter;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.access.exception.AccessDeniedException;
import net.n2oapp.framework.access.exception.UnauthorizedException;
import net.n2oapp.framework.access.metadata.Security;
import net.n2oapp.framework.access.metadata.SecurityFilters;
import net.n2oapp.framework.access.metadata.SecurityObject;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectFilter;
import net.n2oapp.framework.access.simple.PermissionApi;
import net.n2oapp.framework.api.context.Context;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.user.UserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SecurityProvider {
    private final PermissionApi permissionApi;
    private final boolean strictFiltering;
    private static final Logger logger = LoggerFactory.getLogger(SecurityProvider.class);

    public SecurityProvider(PermissionApi permissionApi, boolean strictFiltering) {
        this.permissionApi = permissionApi;
        this.strictFiltering = strictFiltering;
    }

    public void checkAccess(Security security, UserContext userContext) {
        if (CollectionUtils.isEmpty((Collection)security)) {
            return;
        }
        for (SecurityObject securityObject : ((Map)security.get(0)).values()) {
            this.check(userContext, securityObject);
        }
    }

    public List<Restriction> collectRestrictions(SecurityFilters securityFilters, UserContext userContext) {
        if (securityFilters == null) {
            return Collections.emptyList();
        }
        HashSet<N2oObjectFilter> filters = new HashSet<N2oObjectFilter>();
        HashSet<String> removeFilters = new HashSet<String>();
        if (securityFilters.getPermitAllFilters() != null) {
            filters.addAll(securityFilters.getPermitAllFilters());
        }
        if (securityFilters.getRemovePermitAllFilters() != null) {
            removeFilters.addAll(securityFilters.getRemovePermitAllFilters());
        }
        if (this.permissionApi.hasAuthentication(userContext)) {
            if (securityFilters.getAuthenticatedFilters() != null) {
                filters.addAll(securityFilters.getAuthenticatedFilters());
            }
            if (securityFilters.getRemoveAuthenticatedFilters() != null) {
                removeFilters.addAll(securityFilters.getRemoveAuthenticatedFilters());
            }
        } else {
            if (securityFilters.getAnonymousFilters() != null) {
                filters.addAll(securityFilters.getAnonymousFilters());
            }
            if (securityFilters.getRemoveAnonymousFilters() != null) {
                removeFilters.addAll(securityFilters.getRemoveAnonymousFilters());
            }
        }
        if (securityFilters.getRoleFilters() != null) {
            securityFilters.getRoleFilters().keySet().stream().filter(r -> this.permissionApi.hasRole(userContext, (String)r)).forEach(r -> filters.addAll((Collection)securityFilters.getRoleFilters().get(r)));
        }
        if (securityFilters.getRemoveRoleFilters() != null) {
            securityFilters.getRemoveRoleFilters().keySet().stream().filter(r -> this.permissionApi.hasRole(userContext, (String)r)).forEach(r -> removeFilters.addAll((Collection)securityFilters.getRemoveRoleFilters().get(r)));
        }
        if (securityFilters.getPermissionFilters() != null) {
            securityFilters.getPermissionFilters().keySet().stream().filter(p -> this.permissionApi.hasPermission(userContext, (String)p)).forEach(p -> filters.addAll((Collection)securityFilters.getPermissionFilters().get(p)));
        }
        if (securityFilters.getRemovePermissionFilters() != null) {
            securityFilters.getRemovePermissionFilters().keySet().stream().filter(p -> this.permissionApi.hasPermission(userContext, (String)p)).forEach(p -> removeFilters.addAll((Collection)securityFilters.getRemovePermissionFilters().get(p)));
        }
        if (securityFilters.getUserFilters() != null) {
            securityFilters.getUserFilters().keySet().stream().filter(u -> this.permissionApi.hasUsername(userContext, (String)u)).forEach(u -> filters.addAll((Collection)securityFilters.getUserFilters().get(u)));
        }
        if (securityFilters.getRemoveUserFilters() != null) {
            securityFilters.getRemoveUserFilters().keySet().stream().filter(u -> this.permissionApi.hasUsername(userContext, (String)u)).forEach(u -> removeFilters.addAll((Collection)securityFilters.getRemoveUserFilters().get(u)));
        }
        filters.removeIf(f -> removeFilters.contains(f.getId()));
        return filters.stream().map(this::restriction).toList();
    }

    private Restriction restriction(N2oObjectFilter filter) {
        Object value = filter.isArray() ? Arrays.asList(filter.getValues()) : filter.getValue();
        return new Restriction(filter.getId(), filter.getFieldId(), value, filter.getType());
    }

    public void checkObjectRestrictions(DataSet data, SecurityFilters securityFilters, UserContext userContext) {
        this.checkRestrictions(securityFilters, userContext, r -> data.get((Object)r.getId()));
    }

    public void checkQueryRestrictions(DataSet data, SecurityFilters securityFilters, UserContext userContext, Map<String, Map<FilterType, N2oQuery.Filter>> filtersMap) {
        this.checkRestrictions(securityFilters, userContext, r -> {
            if (filtersMap.get(r.getFieldId()) == null) {
                logger.warn("\u0412 \u0441\u0445\u0435\u043c\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0443\u043a\u0430\u0437\u0430\u043d \u0444\u0438\u043b\u044c\u0442\u0440 {}, \u043d\u043e \u0435\u0433\u043e \u043d\u0435\u0442 \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435", (Object)r.getFieldId());
                return null;
            }
            N2oQuery.Filter filter = (N2oQuery.Filter)((Map)filtersMap.get(r.getFieldId())).get(r.getType());
            return filter != null ? data.get((Object)filter.getFilterId()) : null;
        });
    }

    private void checkRestrictions(SecurityFilters securityFilters, UserContext userContext, Function<Restriction, Object> realValueFunction) {
        List<Restriction> restrictions = this.collectRestrictions(securityFilters, userContext);
        ContextProcessor contextProcessor = new ContextProcessor((Context)userContext);
        for (Restriction securityRestriction : restrictions) {
            Object realValue = realValueFunction.apply(securityRestriction);
            if (realValue == null && !this.strictFiltering) continue;
            if (FilterType.Arity.nullary.equals((Object)securityRestriction.getType().arity)) {
                Filter securityFilter = new Filter(securityRestriction.getType());
                this.checkByField(securityRestriction.getFieldId(), realValue, securityFilter);
                continue;
            }
            Object filterValue = contextProcessor.resolve(securityRestriction.getValue());
            if (filterValue == null) continue;
            Filter securityFilter = new Filter(filterValue, securityRestriction.getType());
            this.checkByField(securityRestriction.getFieldId(), realValue, securityFilter);
        }
    }

    private void checkByField(String fieldId, Object realValue, Filter securityFilter) {
        if (!securityFilter.check(realValue)) {
            throw new AccessDeniedException("Access denied by field " + fieldId);
        }
    }

    private void check(UserContext userContext, SecurityObject securityObject) {
        if (securityObject.getDenied() != null && securityObject.getDenied().booleanValue()) {
            throw new UnauthorizedException();
        }
        if (securityObject.getPermitAll() != null && securityObject.getPermitAll().booleanValue()) {
            return;
        }
        if (!this.permissionApi.hasAuthentication(userContext)) {
            if (securityObject.getAnonymous() != null && securityObject.getAnonymous().booleanValue()) {
                return;
            }
            throw new UnauthorizedException();
        }
        if (securityObject.getAuthenticated() != null && securityObject.getAuthenticated().booleanValue()) {
            return;
        }
        if (securityObject.getAnonymous() != null && securityObject.getAnonymous().booleanValue()) {
            throw new AccessDeniedException();
        }
        if (!this.checkAccessList(userContext, securityObject.getRoles(), this.permissionApi::hasRole)) {
            if (!this.checkAccessList(userContext, securityObject.getPermissions(), this.permissionApi::hasPermission)) {
                if (!this.checkAccessList(userContext, securityObject.getUsernames(), this.permissionApi::hasUsername)) {
                    throw new AccessDeniedException();
                }
            }
        }
    }

    private boolean checkAccessList(UserContext userContext, Set<String> accessList, BiPredicate<UserContext, String> f) {
        if (accessList == null) {
            return false;
        }
        for (String param : accessList) {
            if (!f.test(userContext, param)) continue;
            return true;
        }
        return false;
    }
}

