/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.integration;

import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.access.data.SecurityProvider;
import net.n2oapp.framework.access.metadata.Security;
import net.n2oapp.framework.access.metadata.SecurityFilters;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.global.view.page.DefaultValuesMode;
import net.n2oapp.framework.api.processing.DataProcessing;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.ActionResponseInfo;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;

public class N2oSecurityModule
implements DataProcessing {
    private SecurityProvider securityProvider;

    public N2oSecurityModule(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public void processAction(ActionRequestInfo requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        this.securityProvider.checkAccess(this.getSecurityObject((PropertiesAware)requestInfo.getOperation()), requestInfo.getUser());
        this.securityProvider.checkObjectRestrictions(dataSet, this.getSecurityFilters((PropertiesAware)requestInfo.getOperation()), requestInfo.getUser());
    }

    public void processQuery(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        Security security;
        if (requestInfo.getMode().equals((Object)DefaultValuesMode.query) && (security = this.getSecurityObject((PropertiesAware)requestInfo.getQuery())) != null) {
            this.securityProvider.checkAccess(security, requestInfo.getUser());
            List<Restriction> securityFilters = this.securityProvider.collectRestrictions(this.getSecurityFilters((PropertiesAware)requestInfo.getQuery()), requestInfo.getUser());
            requestInfo.getCriteria().addRestrictions(securityFilters);
        }
    }

    public void processQueryResult(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, CollectionPage<DataSet> page) {
        if (DefaultValuesMode.query.equals((Object)requestInfo.getMode()) && requestInfo.getSize() == 1) {
            DataSet data = (DataSet)page.getCollection().iterator().next();
            this.securityProvider.checkAccess(this.getSecurityObject((PropertiesAware)requestInfo.getQuery()), requestInfo.getUser());
            this.securityProvider.checkQueryRestrictions(data, this.getSecurityFilters((PropertiesAware)requestInfo.getQuery()), requestInfo.getUser(), requestInfo.getQuery().getFiltersMap());
        }
    }

    private Security getSecurityObject(PropertiesAware propertiesAware) {
        Map properties = propertiesAware.getProperties();
        if (properties == null || !properties.containsKey(Security.SECURITY_PROP_NAME) || ((Security)properties.get(Security.SECURITY_PROP_NAME)).getSecurityMap() == null) {
            return null;
        }
        return (Security)properties.get(Security.SECURITY_PROP_NAME);
    }

    private SecurityFilters getSecurityFilters(PropertiesAware propertiesAware) {
        Map properties = propertiesAware.getProperties();
        if (properties == null || !properties.containsKey("securityFilters")) {
            return null;
        }
        return (SecurityFilters)properties.get("securityFilters");
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }
}

