/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.mock;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.access.simple.PermissionApi;
import net.n2oapp.framework.api.user.UserContext;

public class PermissionApiMock
implements PermissionApi {
    public List<String> permission = new ArrayList<String>();
    public List<String> roles = new ArrayList<String>();
    public List<String> users = new ArrayList<String>();
    private List<String> allowedPermissions = new ArrayList<String>();
    private List<String> allowedRoles = new ArrayList<String>();

    @Override
    public boolean hasPermission(UserContext user, String permissionId) {
        this.permission.add(permissionId);
        return this.allowedPermissions.contains(permissionId);
    }

    @Override
    public boolean hasRole(UserContext user, String roleId) {
        this.roles.add(roleId);
        return this.allowedRoles.contains(roleId);
    }

    @Override
    public boolean hasAuthentication(UserContext user) {
        return false;
    }

    @Override
    public boolean hasUsername(UserContext user, String name) {
        this.users.add(name);
        return false;
    }

    public void addAllowedPermission(String allowedPermission) {
        this.allowedPermissions.add(allowedPermission);
    }

    public void addAllowedRole(String allowedRole) {
        this.allowedRoles.add(allowedRole);
    }

    public void clearAllowedPermissions() {
        this.allowedPermissions.clear();
    }

    public void clearCalls() {
        this.roles.clear();
        this.permission.clear();
        this.users.clear();
    }
}

