/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.integration.metadata.transform;

import net.n2oapp.framework.access.integration.metadata.transform.BaseAccessTransformer;
import net.n2oapp.framework.access.metadata.schema.AccessContext;
import net.n2oapp.framework.access.metadata.schema.simple.SimpleCompiledAccessSchema;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.application.Application;
import net.n2oapp.framework.api.metadata.application.Sidebar;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.header.Header;
import net.n2oapp.framework.api.metadata.header.HeaderItem;
import net.n2oapp.framework.api.metadata.header.SimpleMenu;
import net.n2oapp.framework.config.metadata.compile.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ApplicationAccessTransformer
extends BaseAccessTransformer<Application, ApplicationContext> {
    public Class<? extends Compiled> getCompiledClass() {
        return Application.class;
    }

    public Application transform(Application compiled, ApplicationContext context, CompileProcessor p) {
        SimpleCompiledAccessSchema accessSchema = (SimpleCompiledAccessSchema)p.getCompiled((CompileContext)new AccessContext((String)p.resolve(Placeholders.property((String)"n2o.access.schema.id"), String.class)));
        this.transformHeader(compiled.getHeader(), accessSchema, p);
        if (compiled.getSidebars() != null) {
            for (Sidebar sidebar : compiled.getSidebars()) {
                this.transformSidebar(sidebar, accessSchema, p);
            }
        }
        return compiled;
    }

    private void transformHeader(Header compiled, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        if (compiled == null) {
            return;
        }
        this.mapSecurityItems(compiled.getMenu(), schema, p);
        this.mapSecurityItems(compiled.getExtraMenu(), schema, p);
    }

    private void transformSidebar(Sidebar compiled, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        if (compiled == null) {
            return;
        }
        this.mapSecurityItems(compiled.getMenu(), schema, p);
        this.mapSecurityItems(compiled.getExtraMenu(), schema, p);
    }

    private void mapSecurityItems(SimpleMenu simpleMenu, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        if (simpleMenu == null || simpleMenu.getItems() == null) {
            return;
        }
        for (HeaderItem item : simpleMenu.getItems()) {
            if (item.getSubItems() == null) {
                this.mapSecurityItem(schema, p, item);
                continue;
            }
            item.getSubItems().forEach(si -> this.mapSecurityItem(schema, p, (HeaderItem)si));
        }
    }

    private void mapSecurityItem(SimpleCompiledAccessSchema schema, CompileProcessor p, HeaderItem si) {
        this.collectPageAccess((PropertiesAware)si, si.getPageId(), schema, p);
        if (si.getPageId() == null) {
            this.collectUrlAccess((PropertiesAware)si, si.getHref(), schema, p);
        } else {
            String objectId = ((N2oPage)p.getSource(si.getPageId(), N2oPage.class)).getObjectId();
            this.collectObjectAccess((PropertiesAware)si, objectId, null, schema, p);
        }
    }
}

