/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.integration.metadata.transform;

import java.util.List;
import net.n2oapp.framework.access.integration.metadata.transform.BaseAccessTransformer;
import net.n2oapp.framework.access.metadata.schema.AccessContext;
import net.n2oapp.framework.access.metadata.schema.simple.SimpleCompiledAccessSchema;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.Itemable;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.meta.page.StandardPage;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.api.metadata.meta.region.RegionItem;
import org.springframework.stereotype.Component;

@Component
public class PageAccessTransformer
extends BaseAccessTransformer<StandardPage, CompileContext<?, ?>> {
    public Class<? extends Compiled> getCompiledClass() {
        return StandardPage.class;
    }

    public StandardPage transform(StandardPage compiled, CompileContext context, CompileProcessor p) {
        SimpleCompiledAccessSchema accessSchema = (SimpleCompiledAccessSchema)p.getCompiled((CompileContext)new AccessContext((String)p.resolve(Placeholders.property((String)"n2o.access.schema.id"), String.class)));
        if (compiled.getRegions() != null) {
            for (List regions : compiled.getRegions().values()) {
                this.transform(regions);
            }
        }
        this.collectPageAccess((PropertiesAware)compiled, context.getSourceId((BindProcessor)p), accessSchema, p);
        return compiled;
    }

    private void transform(List<? extends Compiled> compiledList) {
        for (Compiled compiled : compiledList) {
            if (compiled instanceof Itemable) {
                for (RegionItem item : ((Itemable)compiled).getItems()) {
                    if (item.getContent() == null) continue;
                    this.transform(item.getContent());
                    this.merge((PropertiesAware)item, item.getContent());
                }
                continue;
            }
            if (!(compiled instanceof Region) || ((Region)compiled).getContent() == null) continue;
            Region region = (Region)compiled;
            this.transform(region.getContent());
            this.merge((PropertiesAware)region, region.getContent());
        }
    }
}

