/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.metadata.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.n2oapp.framework.access.functions.StreamUtil;
import net.n2oapp.framework.access.metadata.accesspoint.AccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oColumnAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oContainerAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oFilterAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oMenuItemAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oModuleAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oPageAccessPoint;
import net.n2oapp.framework.access.metadata.compile.AccessSchemaCompiler;
import net.n2oapp.framework.access.metadata.schema.AccessContext;
import net.n2oapp.framework.access.metadata.schema.permission.N2oPermission;
import net.n2oapp.framework.access.metadata.schema.role.N2oRole;
import net.n2oapp.framework.access.metadata.schema.simple.N2oSimpleAccessSchema;
import net.n2oapp.framework.access.metadata.schema.simple.ReproducerAccessPoint;
import net.n2oapp.framework.access.metadata.schema.simple.SimpleCompiledAccessSchema;
import net.n2oapp.framework.access.metadata.schema.user.N2oUserAccess;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import org.springframework.stereotype.Component;

@Component
public class SimpleAccessSchemaCompiler
extends AccessSchemaCompiler<SimpleCompiledAccessSchema, N2oSimpleAccessSchema> {
    public Class<? extends Source> getSourceClass() {
        return N2oSimpleAccessSchema.class;
    }

    public SimpleCompiledAccessSchema compile(N2oSimpleAccessSchema source, AccessContext context, CompileProcessor p) {
        SimpleCompiledAccessSchema compiled = new SimpleCompiledAccessSchema();
        this.compileAccess(compiled, source, context, p);
        if (source.getN2oPermissions() != null) {
            this.reproduce(source.getN2oPermissions(), N2oPermission::getAccessPoints, N2oPermission::setAccessPoints, p);
            compiled.setN2oPermissions(Arrays.asList(source.getN2oPermissions()));
        }
        if (source.getN2oRoles() != null) {
            this.reproduce(source.getN2oRoles(), N2oRole::getAccessPoints, N2oRole::setAccessPoints, p);
            compiled.setN2oRoles(Arrays.asList(source.getN2oRoles()));
        }
        if (source.getPermitAllPoints() != null) {
            compiled.setPermitAllPoints(this.reproduceAccessPoints(source.getPermitAllPoints(), p));
        }
        if (source.getAuthenticatedPoints() != null) {
            compiled.setAuthenticatedPoints(this.reproduceAccessPoints(source.getAuthenticatedPoints(), p));
        }
        if (source.getN2oUserAccesses() != null) {
            this.reproduce(source.getN2oUserAccesses(), N2oUserAccess::getAccessPoints, N2oUserAccess::setAccessPoints, p);
            compiled.setN2oUserAccesses(Arrays.asList(source.getN2oUserAccesses()));
        }
        if (source.getAnonymousPoints() != null) {
            compiled.setAnonymousPoints(this.reproduceAccessPoints(source.getAnonymousPoints(), p));
        }
        return compiled;
    }

    private <T> void reproduce(T[] val, Function<T, AccessPoint[]> getter, BiConsumer<T, AccessPoint[]> setter, CompileProcessor p) {
        StreamUtil.safeStreamOf(val).forEach(v -> {
            List<AccessPoint> accessPoints = this.reproduceAccessPoints((AccessPoint[])getter.apply(v), p);
            setter.accept(v, accessPoints.toArray(new AccessPoint[accessPoints.size()]));
        });
    }

    private List<AccessPoint> reproduceAccessPoints(AccessPoint[] points, CompileProcessor p) {
        if (points == null) {
            return Collections.emptyList();
        }
        ArrayList<AccessPoint> accessPoints = new ArrayList<AccessPoint>(Arrays.asList(points));
        Arrays.stream(points).forEach(ac -> this.reproduceAccessPoint((AccessPoint)ac, (List<AccessPoint>)accessPoints, p));
        return accessPoints;
    }

    private void reproduceAccessPoint(AccessPoint accessPoint, List<AccessPoint> pointList, CompileProcessor p) {
        if (accessPoint instanceof N2oObjectAccessPoint) {
            ReproducerAccessPoint.reproduceAccessPoint((N2oObjectAccessPoint)accessPoint, pointList, p);
        } else if (accessPoint instanceof N2oModuleAccessPoint) {
            ReproducerAccessPoint.reproduceAccessPoint((N2oModuleAccessPoint)accessPoint, pointList);
        } else if (accessPoint instanceof N2oPageAccessPoint) {
            ReproducerAccessPoint.reproduceAccessPoint((N2oPageAccessPoint)accessPoint, pointList);
        } else if (accessPoint instanceof N2oContainerAccessPoint) {
            ReproducerAccessPoint.reproduceAccessPoint((N2oContainerAccessPoint)accessPoint, pointList);
        } else if (accessPoint instanceof N2oMenuItemAccessPoint) {
            ReproducerAccessPoint.reproduceAccessPoint((N2oMenuItemAccessPoint)accessPoint, pointList);
        } else if (accessPoint instanceof N2oColumnAccessPoint) {
            ReproducerAccessPoint.reproduceAccessPoint((N2oColumnAccessPoint)accessPoint, pointList);
        } else if (accessPoint instanceof N2oFilterAccessPoint) {
            ReproducerAccessPoint.reproduceAccessPoint((N2oFilterAccessPoint)accessPoint, pointList);
        }
    }
}

