/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.engine.factory.locator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.n2oapp.engine.factory.MultiEngineFactory;
import net.n2oapp.engine.factory.integration.spring.OverrideBean;
import net.n2oapp.engine.factory.locator.EngineLocator;

public class SimpleEngineLocator<G>
implements EngineLocator<G> {
    private Collection<G> engines;

    public SimpleEngineLocator(Map<String, G> beans) {
        this.engines = new ArrayList<G>(OverrideBean.removeOverriddenBeans(beans).values());
    }

    @Override
    public <T> MultiEngineFactory<T, G> locate(BiPredicate<G, T> predicate) {
        return type -> this.engines.stream().filter(g -> predicate.test(g, type)).collect(Collectors.toList());
    }

    public void add(G engine) {
        this.engines.add(engine);
    }
}

