/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.engine.factory;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.n2oapp.engine.factory.EngineFactory;
import net.n2oapp.engine.factory.EngineNotFoundException;

public abstract class CachedEngineFactory<T, G>
implements EngineFactory<T, G> {
    private volatile Map<T, G> engines;

    @Override
    public G produce(T type) {
        G engine = this.getEngine(type);
        if (engine == null) {
            throw new EngineNotFoundException(type);
        }
        return engine;
    }

    private synchronized void initFactory() {
        if (this.engines == null) {
            Collection<G> engineBeans = this.findEngines();
            HashMap<T, G> result = new HashMap<T, G>();
            for (G engine : engineBeans) {
                result.put(this.getType(engine), engine);
            }
            this.engines = result;
        }
    }

    protected G getEngine(T type) {
        if (this.engines == null) {
            this.initFactory();
        }
        return this.engines.get(type);
    }

    public abstract Collection<G> findEngines();

    public abstract T getType(G var1);
}

