package net.mready.frameplayer.compose

import androidx.appcompat.view.ContextThemeWrapper
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.viewinterop.AndroidView
import androidx.mediarouter.app.MediaRouteButton
import com.google.android.gms.cast.framework.CastButtonFactory

@Composable
fun MediaRouteButton(
    modifier: Modifier = Modifier
) {
    AndroidView(
        modifier = modifier,
        factory = { context ->
            val contextWrapper = ContextThemeWrapper(context, R.style.MediaButtonStyle)
            MediaRouteButton(contextWrapper).apply {
                CastButtonFactory.setUpMediaRouteButton(context, this)
            }
        }
    )
}