/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.redis.script.manager.lettuce;

import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.ScriptOutputType;
import com.lambdaworks.redis.api.sync.RedisScriptingCommands;
import net.moznion.redis.script.manager.core.ScriptManager;

public class LettuceScriptManager<K, V>
extends ScriptManager<K, V> {
    private static final Object[] EMPTY_VALUE = new Object[0];
    private final RedisScriptingCommands<K, V> commands;
    private final V script;
    private final boolean useEvalSHA;
    private final ScriptOutputType outputType;
    boolean isNoScript;

    public LettuceScriptManager(RedisScriptingCommands<K, V> commands, V script, ScriptOutputType outputType) {
        this(commands, script, null, outputType, true);
    }

    public LettuceScriptManager(RedisScriptingCommands<K, V> commands, V script, String sha1, ScriptOutputType outputType) {
        this(commands, script, sha1, outputType, true);
    }

    public LettuceScriptManager(RedisScriptingCommands<K, V> commands, V script, ScriptOutputType outputType, boolean useEvalSHA) {
        this(commands, script, null, outputType, useEvalSHA);
    }

    public LettuceScriptManager(RedisScriptingCommands<K, V> commands, V script, String sha1, ScriptOutputType outputType, boolean useEvalSHA) {
        super(sha1);
        this.commands = commands;
        this.script = script;
        this.outputType = outputType;
        this.useEvalSHA = useEvalSHA;
        this.isNoScript = true;
    }

    public Object eval(K[] keys) {
        return this.eval(keys, EMPTY_VALUE);
    }

    public Object eval(K[] keys, V[] values) {
        block3: {
            this.isNoScript = false;
            if (this.useEvalSHA) {
                String sha1 = this.getSHA1(this.script);
                try {
                    return this.commands.evalsha(sha1, this.outputType, (Object[])keys, (Object[])values);
                }
                catch (RedisCommandExecutionException e) {
                    if (e.getMessage().contains("NOSCRIPT")) break block3;
                    throw e;
                }
            }
        }
        this.isNoScript = true;
        return this.commands.eval(this.script.toString(), this.outputType, (Object[])keys, (Object[])values);
    }
}

