/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.arnold.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import net.moznion.arnold.annotation.Required;
import net.moznion.arnold.exception.ArnoldAnnotationProcessingFailedException;
import net.moznion.arnold.exception.BuildingInstanceFailedException;

@SupportedAnnotationTypes(value={"net.moznion.arnold.annotation.ArnoldBuilder"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ArnoldProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        if (annotations.size() == 0) {
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                ArrayList<FieldUnit> fieldUnits = new ArrayList<FieldUnit>();
                String packageName = this.processingEnv.getElementUtils().getPackageOf(element).toString();
                String builderClassNameBase = element.getSimpleName() + "Builder";
                List<Element> fieldsForBuilding = ArnoldProcessor.collectFieldsForBuilding(element.getEnclosedElements());
                if (fieldsForBuilding.isEmpty()) continue;
                int fieldNum = fieldsForBuilding.size();
                int cursor = 0;
                for (Element targetField : fieldsForBuilding) {
                    String generatedClassName = ArnoldProcessor.appendSuffix(builderClassNameBase, cursor);
                    String rawFieldName = targetField.getSimpleName().toString();
                    String internalFieldName = "__" + rawFieldName + cursor;
                    TypeName fieldType = TypeName.get((TypeMirror)targetField.asType());
                    fieldUnits.add(new FieldUnit(rawFieldName, internalFieldName, fieldType));
                    MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
                    if (cursor == 0) {
                        constructorBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
                    }
                    TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)generatedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
                    for (int i = 0; i < cursor; ++i) {
                        FieldUnit fieldUnit = (FieldUnit)fieldUnits.get(i);
                        String varName = fieldUnit.internalFieldName;
                        TypeName type = fieldUnit.typeName;
                        constructorBuilder.addParameter(type, varName, new Modifier[0]).addStatement("this.$N = $N", new Object[]{varName, varName});
                        classBuilder.addField(type, varName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    }
                    MethodSpec setter = ArnoldProcessor.buildSetterMethod(fieldUnits, rawFieldName, fieldType, packageName, builderClassNameBase + (cursor + 1), cursor);
                    TypeSpec generatedClass = classBuilder.addMethod(constructorBuilder.build()).addMethod(setter).build();
                    try {
                        this.outputJavaFile(packageName, generatedClass, generatedClassName);
                    }
                    catch (IOException e) {
                        messager.printMessage(Diagnostic.Kind.ERROR, "Failed annotation processing");
                        throw new ArnoldAnnotationProcessingFailedException(e);
                    }
                    ++cursor;
                }
                String terminationBuilderClassName = builderClassNameBase + fieldNum;
                MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
                TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)terminationBuilderClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
                for (int i = 0; i < fieldNum; ++i) {
                    FieldUnit fieldUnit = (FieldUnit)fieldUnits.get(i);
                    String varName = fieldUnit.internalFieldName;
                    TypeName type = fieldUnit.typeName;
                    constructorBuilder.addParameter(type, varName, new Modifier[0]).addStatement("this.$N = $N", new Object[]{varName, varName});
                    classBuilder.addField(type, varName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                }
                MethodSpec constructor = constructorBuilder.build();
                MethodSpec.Builder builderBuilder = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)element.asType())).beginControlFlow("try", new Object[0]).addStatement("final $T __obj = $T.class.newInstance()", new Object[]{element.asType(), element.asType()}).addStatement("final Class<?> __clazz = __obj.getClass()", new Object[0]);
                int cnt = 0;
                for (FieldUnit fieldUnit : fieldUnits) {
                    builderBuilder.addStatement("final $T __field$L = __clazz.getDeclaredField($S)", new Object[]{Field.class, cnt, fieldUnit.rawFieldName}).addStatement("__field$L.setAccessible(true)", new Object[]{cnt}).addStatement("__field$L.set(__obj, this.$N)", new Object[]{cnt, fieldUnit.internalFieldName});
                    ++cnt;
                }
                MethodSpec builder = builderBuilder.addStatement("return __obj", new Object[0]).nextControlFlow("catch ($T|$T|$T e)", new Object[]{IllegalAccessException.class, InstantiationException.class, NoSuchFieldException.class}).addStatement("throw new $T(e)", new Object[]{BuildingInstanceFailedException.class}).endControlFlow().build();
                TypeSpec terminationBuilder = classBuilder.addMethod(constructor).addMethod(builder).build();
                try {
                    this.outputJavaFile(packageName, terminationBuilder, terminationBuilderClassName);
                }
                catch (IOException e) {
                    messager.printMessage(Diagnostic.Kind.ERROR, "Failed annotation processing");
                    throw new ArnoldAnnotationProcessingFailedException(e);
                }
            }
        }
        return true;
    }

    private void outputJavaFile(String packageName, TypeSpec generatedClass, String generatedClassName) throws IOException {
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)generatedClass).build();
        Filer filer = this.processingEnv.getFiler();
        JavaFileObject f = filer.createSourceFile(packageName + "." + generatedClassName, new Element[0]);
        try (Writer writer = f.openWriter();){
            javaFile.writeTo((Appendable)writer);
            writer.close();
        }
    }

    private static List<Element> collectFieldsForBuilding(List<? extends Element> elements) {
        Supplier<Stream> streamSupplier = () -> elements.stream().filter(e -> e.getKind().isField()).filter(e -> {
            Set<Modifier> mods = e.getModifiers();
            boolean isFinal = mods.contains((Object)Modifier.FINAL);
            Boolean isStatic = mods.contains((Object)Modifier.STATIC);
            boolean isRequired = e.getAnnotation(Required.class) != null;
            return (isFinal || isRequired) && isStatic == false;
        });
        Stream<Element> orderedFields = streamSupplier.get().filter(e -> e.getAnnotation(Required.class) != null && e.getAnnotation(Required.class).order() >= 0).sorted(Comparator.comparing(e -> e.getAnnotation(Required.class).order()));
        Stream<Element> nonOrderedFields = streamSupplier.get().filter(e -> e.getAnnotation(Required.class) == null || e.getAnnotation(Required.class).order() < 0);
        return Stream.concat(nonOrderedFields, orderedFields).collect(Collectors.toList());
    }

    private static String appendSuffix(String base, int suffix) {
        return base + (suffix == 0 ? "" : Integer.valueOf(suffix));
    }

    private static MethodSpec buildSetterMethod(List<FieldUnit> fieldUnits, String fieldName, TypeName fieldType, String packageName, String nextBuilderClassName, int numOfBuilder) {
        String serializedArgsToInstantiate = IntStream.range(0, numOfBuilder).mapToObj(i -> ((FieldUnit)fieldUnits.get(i)).internalFieldName).collect(Collectors.joining(","));
        if (!serializedArgsToInstantiate.isEmpty()) {
            serializedArgsToInstantiate = serializedArgsToInstantiate + ",";
        }
        return MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)packageName, (String)nextBuilderClassName, (String[])new String[0])).addParameter(fieldType, fieldName, new Modifier[0]).addStatement("return new $N(" + serializedArgsToInstantiate + fieldName + ")", new Object[]{nextBuilderClassName}).build();
    }

    private static class FieldUnit {
        private final String rawFieldName;
        private final String internalFieldName;
        private final TypeName typeName;

        private FieldUnit(String rawFieldName, String internalFieldName, TypeName typeName) {
            this.rawFieldName = rawFieldName;
            this.internalFieldName = internalFieldName;
            this.typeName = typeName;
        }
    }
}

