/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.utils;

import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.utils.Array;

public class MapMask {
    public final boolean[][] v;
    public final int height;
    public final int width;
    private final int tileWidth;
    private final int tileHeight;

    public MapMask(int height, int width, int tileWidth, int tileHeight, Array<TiledMapTileLayer> layers, String propertyKey) {
        this.height = height;
        this.width = width;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.v = new boolean[height][width];
        this.generate(layers, propertyKey);
    }

    public boolean atGrid(int x, int y, boolean outOfBoundsResult) {
        if (x >= this.width || x < 0 || y < 0 || y >= this.height) {
            return outOfBoundsResult;
        }
        return this.v[y][x];
    }

    public boolean atScreen(int x, int y, boolean outOfBoundsResult) {
        return this.atGrid(x / this.tileWidth, y / this.tileHeight, outOfBoundsResult);
    }

    public boolean atScreen(float x, float y, boolean outOfBoundsResult) {
        return this.atGrid((int)x / this.tileWidth, (int)y / this.tileHeight, outOfBoundsResult);
    }

    private void generate(Array<TiledMapTileLayer> layers, String propertyKey) {
        for (TiledMapTileLayer layer : layers) {
            for (int ty = 0; ty < this.height; ++ty) {
                for (int tx = 0; tx < this.width; ++tx) {
                    TiledMapTileLayer.Cell cell = layer.getCell(tx, ty);
                    if (cell == null || cell.getTile() == null || !cell.getTile().getProperties().containsKey(propertyKey)) continue;
                    this.v[ty][tx] = true;
                }
            }
        }
    }
}

