/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.utils;

import com.artemis.Component;
import com.artemis.Entity;
import com.artemis.EntityEdit;
import com.artemis.World;
import net.mostlyoriginal.api.component.basic.Angle;
import net.mostlyoriginal.api.component.basic.Bounds;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.basic.Scale;
import net.mostlyoriginal.api.component.graphics.Anim;
import net.mostlyoriginal.api.component.graphics.Render;
import net.mostlyoriginal.api.component.graphics.Tint;
import net.mostlyoriginal.api.component.physics.Physics;
import net.mostlyoriginal.api.component.ui.Font;
import net.mostlyoriginal.api.component.ui.Label;

public abstract class EntityEditor<T extends EntityEditor> {
    private EntityEdit edit;
    private Entity entity;

    protected T editEntity(Entity entity) {
        this.entity = entity;
        this.edit = entity.edit();
        return (T)this;
    }

    protected final T createEntity(World world) {
        this.editEntity(world.createEntity());
        return (T)this;
    }

    public final T pos(float x, float y) {
        Pos pos = this.add(Pos.class);
        pos.set(x, y);
        return (T)this;
    }

    public final T pos(int x, int y) {
        Pos pos = this.add(Pos.class);
        pos.set(x, y);
        return (T)this;
    }

    public final T bounds(int minx, int miny, int maxx, int maxy) {
        Bounds bounds = this.add(Bounds.class);
        bounds.minx = minx;
        bounds.miny = miny;
        bounds.maxx = maxx;
        bounds.maxy = maxy;
        return (T)this;
    }

    public final T anim(String id) {
        Anim anim = this.add(Anim.class);
        anim.id = id;
        return (T)this;
    }

    protected final <T extends Component> T add(Class<T> componentType) {
        return (T)this.edit.create(componentType);
    }

    public final T renderable(int layer) {
        Render render = this.add(Render.class);
        render.layer = layer;
        return (T)this;
    }

    public final T angle(float rotation) {
        Angle angle = this.add(Angle.class);
        angle.rotation = rotation;
        return (T)this;
    }

    public final T angle(int rotation, int ox, int oy) {
        Angle angle = this.add(Angle.class);
        angle.rotation = rotation;
        angle.ox = ox;
        angle.oy = oy;
        return (T)this;
    }

    public Entity build() {
        Entity tmp = this.entity;
        this.entity = null;
        this.edit = null;
        return tmp;
    }

    public final T with(Class<? extends Component> component) {
        this.edit.create(component);
        return (T)this;
    }

    public final T with(Class<? extends Component> component1, Class<? extends Component> component2) {
        this.edit.create(component1);
        this.edit.create(component2);
        return (T)this;
    }

    public final T with(Class<? extends Component> component1, Class<? extends Component> component2, Class<? extends Component> component3) {
        this.edit.create(component1);
        this.edit.create(component2);
        this.edit.create(component3);
        return (T)this;
    }

    public final T with(Class<? extends Component> component1, Class<? extends Component> component2, Class<? extends Component> component3, Class<? extends Component> component4) {
        this.edit.create(component1);
        this.edit.create(component2);
        this.edit.create(component3);
        this.edit.create(component4);
        return (T)this;
    }

    public final T with(Class<? extends Component> component1, Class<? extends Component> component2, Class<? extends Component> component3, Class<? extends Component> component4, Class<? extends Component> component5) {
        this.edit.create(component1);
        this.edit.create(component2);
        this.edit.create(component3);
        this.edit.create(component4);
        this.edit.create(component5);
        return (T)this;
    }

    public final T with(Class<? extends Component> ... components) {
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            this.edit.create(components[i]);
        }
        return (T)this;
    }

    public final T physics() {
        this.add(Physics.class);
        return (T)this;
    }

    public final T tint(float r, float g, float b, float a) {
        Tint tint = this.add(Tint.class);
        tint.set(r, g, b, a);
        return (T)this;
    }

    public T tint(String hex) {
        Tint tint = this.add(Tint.class);
        tint.setHex(hex);
        return (T)this;
    }

    public T tint(Tint value) {
        Tint tint = this.add(Tint.class);
        tint.set(value);
        return (T)this;
    }

    public T label(String text) {
        Label label = this.add(Label.class);
        label.text = text;
        return (T)this;
    }

    public T font(String name) {
        Font font = this.add(Font.class);
        font.fontName = name;
        return (T)this;
    }

    public final T scale(float scale) {
        Scale scaleComponent = this.add(Scale.class);
        scaleComponent.scale = scale;
        return (T)this;
    }
}

