/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.script;

import com.artemis.Aspect;
import com.artemis.ComponentMapper;
import com.artemis.annotations.Wire;
import com.artemis.systems.IteratingSystem;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.math.MathUtils;
import net.mostlyoriginal.api.component.basic.Bounds;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.graphics.Anim;
import net.mostlyoriginal.api.component.script.EntitySpawner;
import net.mostlyoriginal.api.manager.AbstractEntityFactorySystem;

@Wire
public class EntitySpawnerSystem
extends IteratingSystem {
    public static final MapProperties EMPTY_MAP_PROPERTIES = new MapProperties();
    private ComponentMapper<EntitySpawner> sm;
    private ComponentMapper<Pos> pm;
    private ComponentMapper<Bounds> bm;
    private ComponentMapper<Anim> am;
    private AbstractEntityFactorySystem entityFactorySystem;

    public EntitySpawnerSystem() {
        super(Aspect.all((Class[])new Class[]{EntitySpawner.class, Pos.class, Bounds.class}));
    }

    protected void process(int e) {
        EntitySpawner spawner = (EntitySpawner)this.sm.get(e);
        if (this.am.has(e)) {
            String animId;
            String string = animId = spawner.enabled ? spawner.animActiveId : spawner.animInactiveId;
            if (animId != null) {
                Anim anim = (Anim)this.am.get(e);
                anim.id = animId;
            }
        }
        if (!spawner.enabled || spawner.entityIds.length > 0) {
            return;
        }
        if (spawner.cooldown == Float.MIN_VALUE) {
            this.scheduleSpawn(spawner);
            spawner.cooldown /= 4.0f;
        }
        spawner.cooldown -= this.world.delta;
        if (spawner.cooldown <= 0.0f) {
            Pos pos = (Pos)this.pm.get(e);
            Bounds bounds = (Bounds)this.bm.get(e);
            this.scheduleSpawn(spawner);
            int s = MathUtils.random((int)spawner.minCount, (int)spawner.maxCount);
            for (int i = 0; i < s; ++i) {
                this.entityFactorySystem.createEntity(spawner.entityIds[MathUtils.random((int)0, (int)(spawner.entityIds.length - 1))], (int)(pos.xy.x + bounds.cx()), (int)(pos.xy.y + bounds.cy()), EMPTY_MAP_PROPERTIES);
            }
        }
    }

    private void scheduleSpawn(EntitySpawner spawner) {
        spawner.cooldown = MathUtils.random((float)spawner.minCooldown, (float)spawner.maxCooldown);
    }
}

