/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.render;

import com.artemis.Aspect;
import com.artemis.Component;
import com.artemis.annotations.Wire;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.graphics.Invisible;
import net.mostlyoriginal.api.component.graphics.Render;
import net.mostlyoriginal.api.component.graphics.Tint;
import net.mostlyoriginal.api.component.ui.BitmapFontAsset;
import net.mostlyoriginal.api.component.ui.Label;
import net.mostlyoriginal.api.plugin.extendedcomponentmapper.M;
import net.mostlyoriginal.api.system.camera.CameraSystem;
import net.mostlyoriginal.api.system.delegate.DeferredEntityProcessingSystem;
import net.mostlyoriginal.api.system.delegate.EntityProcessPrincipal;

@Wire
public class LabelRenderSystem
extends DeferredEntityProcessingSystem {
    protected M<Pos> mPos;
    protected M<Label> mLabel;
    protected M<Tint> mTint;
    protected M<BitmapFontAsset> mBitmapFontAsset;
    protected CameraSystem cameraSystem;
    protected SpriteBatch batch;
    private GlyphLayout glyphLayout = new GlyphLayout();

    public LabelRenderSystem(EntityProcessPrincipal principal) {
        super(Aspect.all((Class[])new Class[]{Pos.class, Label.class, Render.class, BitmapFontAsset.class}).exclude(new Class[]{Invisible.class}), principal);
        this.batch = new SpriteBatch(1000);
    }

    protected void begin() {
        this.batch.setProjectionMatrix(this.cameraSystem.camera.combined);
        this.batch.begin();
        this.batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void end() {
        this.batch.end();
    }

    protected boolean checkProcessing() {
        return true;
    }

    protected void process(int e) {
        Label label = (Label)this.mLabel.get(e);
        Pos pos = (Pos)this.mPos.get(e);
        if (label.text != null) {
            BitmapFont font = ((BitmapFontAsset)this.mBitmapFontAsset.get((int)e)).bitmapFont;
            this.batch.setColor(((Tint)this.mTint.getSafe((int)e, (Component)Tint.WHITE)).color);
            switch (label.align) {
                case LEFT: {
                    font.draw((Batch)this.batch, (CharSequence)label.text, pos.xy.x, pos.xy.y);
                    break;
                }
                case RIGHT: {
                    this.glyphLayout.setText(font, (CharSequence)label.text);
                    font.draw((Batch)this.batch, (CharSequence)label.text, pos.xy.x - this.glyphLayout.width, pos.xy.y);
                }
            }
        }
    }
}

