/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.render;

import com.artemis.Aspect;
import com.artemis.Component;
import com.artemis.ComponentMapper;
import com.artemis.annotations.Wire;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import net.mostlyoriginal.api.component.basic.Angle;
import net.mostlyoriginal.api.component.basic.Origin;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.basic.Size;
import net.mostlyoriginal.api.component.graphics.Invisible;
import net.mostlyoriginal.api.component.graphics.Render;
import net.mostlyoriginal.api.component.graphics.SpriteAsset;
import net.mostlyoriginal.api.system.camera.CameraSystem;
import net.mostlyoriginal.api.system.delegate.DeferredEntityProcessingSystem;
import net.mostlyoriginal.api.system.delegate.EntityProcessPrincipal;

@Wire
public class BasicSpriteRenderSystem
extends DeferredEntityProcessingSystem {
    private CameraSystem cameraSystem;
    protected ComponentMapper<SpriteAsset> mSpriteAsset;
    protected ComponentMapper<Pos> mPos;
    protected ComponentMapper<Angle> mAngle;
    protected ComponentMapper<Origin> mOrigin;
    protected ComponentMapper<Size> mSize;
    private static final Origin DEFAULT_ORIGIN = new Origin();
    private static final Size DEFAULT_SIZE = new Size(0.0f, 0.0f, 0.0f);
    private SpriteBatch batch = new SpriteBatch();
    private Angle angle = new Angle(0.0f);
    private TextureRegion region = new TextureRegion();

    public BasicSpriteRenderSystem(EntityProcessPrincipal principal) {
        super(Aspect.all((Class[])new Class[]{Pos.class, SpriteAsset.class, Render.class}).exclude(new Class[]{Invisible.class}), principal);
    }

    protected void process(int e) {
        Pos pos = (Pos)this.mPos.get(e);
        this.batch.setProjectionMatrix(this.cameraSystem.camera.combined);
        this.batch.begin();
        Texture asset = ((SpriteAsset)this.mSpriteAsset.get((int)e)).asset;
        Angle angle = (Angle)this.mAngle.getSafe(e, (Component)this.angle);
        this.region.setTexture(asset);
        this.region.setRegion(0, 0, 32, 32);
        Origin origin = (Origin)this.mOrigin.getSafe(e, (Component)DEFAULT_ORIGIN);
        Size size = (Size)this.mSize.getSafe(e, (Component)DEFAULT_SIZE);
        float ox = size.getX() * origin.getX();
        float oy = size.getY() * origin.getY();
        this.batch.draw(this.region, pos.xy.x - (size.getX() - ox), pos.xy.y - (size.getY() - oy), ox, oy, size.getX(), size.getY(), 1.0f, 1.0f, angle.rotation);
        this.batch.end();
    }
}

