/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.render;

import com.artemis.Aspect;
import com.artemis.Component;
import com.artemis.annotations.Wire;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import net.mostlyoriginal.api.component.basic.Angle;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.basic.Scale;
import net.mostlyoriginal.api.component.graphics.Anim;
import net.mostlyoriginal.api.component.graphics.Invisible;
import net.mostlyoriginal.api.component.graphics.Render;
import net.mostlyoriginal.api.component.graphics.Tint;
import net.mostlyoriginal.api.manager.AbstractAssetSystem;
import net.mostlyoriginal.api.plugin.extendedcomponentmapper.M;
import net.mostlyoriginal.api.system.camera.CameraSystem;
import net.mostlyoriginal.api.system.delegate.DeferredEntityProcessingSystem;
import net.mostlyoriginal.api.system.delegate.EntityProcessPrincipal;

@Wire
public class AnimRenderSystem
extends DeferredEntityProcessingSystem {
    protected M<Pos> mPos;
    protected M<Anim> mAnim;
    protected M<Tint> mTint;
    protected M<Angle> mAngle;
    protected M<Scale> mScale;
    protected CameraSystem cameraSystem;
    protected AbstractAssetSystem abstractAssetSystem;
    protected SpriteBatch batch;

    public AnimRenderSystem(EntityProcessPrincipal principal) {
        super(Aspect.all((Class[])new Class[]{Pos.class, Anim.class, Render.class}).exclude(new Class[]{Invisible.class}), principal);
    }

    protected void initialize() {
        super.initialize();
        this.batch = new SpriteBatch(2000);
    }

    protected void begin() {
        this.batch.setProjectionMatrix(this.cameraSystem.camera.combined);
        this.batch.begin();
    }

    protected void end() {
        this.batch.end();
    }

    protected void process(int e) {
        Anim anim = (Anim)this.mAnim.get(e);
        Pos pos = (Pos)this.mPos.get(e);
        Angle angle = (Angle)this.mAngle.getSafe(e, (Component)Angle.NONE);
        float scale = ((Scale)this.mScale.getSafe((int)e, (Component)Scale.DEFAULT)).scale;
        anim.age += this.world.delta * anim.speed;
        this.batch.setColor(((Tint)this.mTint.getSafe((int)e, (Component)Tint.WHITE)).color);
        if (anim.id != null) {
            this.drawAnimation(anim, angle, pos, anim.id, scale);
        }
        if (anim.id2 != null) {
            this.drawAnimation(anim, angle, pos, anim.id2, scale);
        }
    }

    private float roundToPixels(float val) {
        return (float)((int)(val * this.cameraSystem.zoom)) / this.cameraSystem.zoom;
    }

    private void drawAnimation(Anim animation, Angle angle, Pos position, String id, float scale) {
        if (animation.age < 0.0f) {
            return;
        }
        Animation gdxanim = this.abstractAssetSystem.get(id);
        if (gdxanim == null) {
            return;
        }
        TextureRegion frame = (TextureRegion)gdxanim.getKeyFrame(animation.age, animation.loop);
        if (animation.flippedX) {
            this.batch.draw(frame.getTexture(), this.roundToPixels(position.xy.x), this.roundToPixels(position.xy.y), angle.ox == Integer.MIN_VALUE ? (float)frame.getRegionWidth() * scale * 0.5f : (float)angle.ox, angle.oy == Integer.MIN_VALUE ? (float)frame.getRegionHeight() * scale * 0.5f : (float)angle.oy, (float)frame.getRegionWidth() * scale, (float)frame.getRegionHeight() * scale, 1.0f, 1.0f, angle.rotation, frame.getRegionX(), frame.getRegionY(), frame.getRegionWidth(), frame.getRegionHeight(), true, false);
        } else if (angle.rotation != 0.0f) {
            this.batch.draw(frame, this.roundToPixels(position.xy.x), this.roundToPixels(position.xy.y), angle.ox == Integer.MIN_VALUE ? (float)frame.getRegionWidth() * scale * 0.5f : (float)angle.ox, angle.oy == Integer.MIN_VALUE ? (float)frame.getRegionHeight() * scale * 0.5f : (float)angle.oy, (float)frame.getRegionWidth() * scale, (float)frame.getRegionHeight() * scale, 1.0f, 1.0f, angle.rotation);
        } else {
            this.batch.draw(frame, this.roundToPixels(position.xy.x), this.roundToPixels(position.xy.y), (float)frame.getRegionWidth() * scale, (float)frame.getRegionHeight() * scale);
        }
    }
}

