/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.physics;

import com.artemis.Aspect;
import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.artemis.annotations.Wire;
import com.artemis.systems.IteratingSystem;
import com.badlogic.gdx.math.Vector2;
import net.mostlyoriginal.api.component.basic.Angle;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.map.MapWallSensor;
import net.mostlyoriginal.api.component.physics.Frozen;
import net.mostlyoriginal.api.component.physics.Physics;

@Wire
public class PhysicsSystem
extends IteratingSystem {
    public static final float AIR_FRICTION = 0.25f;
    public static final int FLOOR_FRICTION = 1;
    private ComponentMapper<Physics> ym;
    private ComponentMapper<Frozen> frozenm;
    private ComponentMapper<Pos> pm;
    private ComponentMapper<Angle> am;
    private ComponentMapper<MapWallSensor> wm;
    private Vector2 vTmp = new Vector2();

    public PhysicsSystem() {
        super(Aspect.all((Class[])new Class[]{Physics.class, Pos.class}));
    }

    public void push(Entity entity, float rotation, float force) {
        if (this.ym.has(entity)) {
            this.vTmp.set(force, 0.0f).setAngle(rotation);
            Physics physics = (Physics)this.ym.get(entity);
            physics.vx += this.vTmp.x;
            physics.vy += this.vTmp.y;
        }
    }

    public void clampVelocity(int entity, float minSpeed, float maxSpeed) {
        if (this.ym.has(entity)) {
            Physics physics = (Physics)this.ym.get(entity);
            this.clampVelocity(physics, minSpeed, maxSpeed);
        }
    }

    private void clampVelocity(Physics physics, float minSpeed, float maxSpeed) {
        this.vTmp.set(physics.vx, physics.vy).clamp(minSpeed, maxSpeed);
        physics.vx = this.vTmp.x;
        physics.vy = this.vTmp.y;
    }

    protected void process(int e) {
        Physics physics = (Physics)this.ym.get(e);
        Pos pos = (Pos)this.pm.get(e);
        if (this.frozenm.has(e)) {
            return;
        }
        if (physics.maxVelocity < Float.MAX_VALUE) {
            this.clampVelocity(e, 0.0f, physics.maxVelocity);
        }
        pos.xy.x += physics.vx * this.world.getDelta();
        pos.xy.y += physics.vy * this.world.getDelta();
        if (physics.vr != 0.0f && this.am.has(e)) {
            ((Angle)this.am.get((int)e)).rotation += physics.vr * this.world.delta;
        }
        if (physics.friction != 0.0f) {
            this.updateFudgeFriction(physics);
        }
    }

    private void updateFudgeFriction(Physics physics) {
        float adjustedFriction = physics.friction;
        physics.vx = Math.abs(physics.vx) > 0.005f ? (physics.vx -= physics.vx * this.world.delta * adjustedFriction) : 0.0f;
        physics.vr = Math.abs(physics.vr) > 0.005f ? (physics.vr -= physics.vr * this.world.delta * adjustedFriction) : 0.0f;
        physics.vy = Math.abs(physics.vy) > 0.005f ? (physics.vy -= physics.vy * this.world.delta * adjustedFriction * 0.1f) : 0.0f;
    }
}

