/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.physics;

import com.artemis.Aspect;
import com.artemis.ComponentMapper;
import com.artemis.annotations.Wire;
import com.artemis.systems.IteratingSystem;
import com.badlogic.gdx.math.Vector2;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.physics.Attached;
import net.mostlyoriginal.api.component.physics.Homing;
import net.mostlyoriginal.api.component.physics.Physics;

@Wire
public class HomingSystem
extends IteratingSystem {
    ComponentMapper<Homing> hm;
    ComponentMapper<Pos> pm;
    ComponentMapper<Physics> ym;
    ComponentMapper<Attached> am;
    private static final Vector2 tmp = new Vector2();

    public HomingSystem() {
        super(Aspect.all((Class[])new Class[]{Homing.class, Pos.class}));
    }

    protected void process(int e) {
        Homing homing = (Homing)this.hm.get(e);
        int homingTarget = homing.target;
        if (homingTarget != -1) {
            float distance = this.distance(e, homingTarget);
            if (distance < homing.maxDistance) {
                Pos myPos = (Pos)this.pm.get(e);
                Pos tPos = (Pos)this.pm.get(homingTarget);
                tmp.set(tPos.xy.x, tPos.xy.y).sub(myPos.xy.x, myPos.xy.y).scl(homing.speedFactor);
                if (this.ym.has(e)) {
                    Physics physics = (Physics)this.ym.get(e);
                    physics.vx = HomingSystem.tmp.x;
                    physics.vy = HomingSystem.tmp.y;
                }
                if (this.am.has(e)) {
                    Attached attached = (Attached)this.am.get(e);
                    attached.slackX = HomingSystem.tmp.x;
                    attached.slackY = HomingSystem.tmp.y;
                }
            }
        } else {
            homing.target = -1;
        }
    }

    public float distance(int a, int b) {
        Pos pa = (Pos)this.pm.get(a);
        Pos pb = (Pos)this.pm.get(b);
        return tmp.set(pa.xy.x, pa.xy.y).dst(pb.xy.x, pb.xy.y);
    }
}

