/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.physics;

import com.artemis.BaseSystem;
import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.artemis.annotations.Wire;
import net.mostlyoriginal.api.component.basic.Bounds;
import net.mostlyoriginal.api.component.basic.Pos;

@Wire
public class CollisionSystem
extends BaseSystem {
    private ComponentMapper<Bounds> bm;
    private ComponentMapper<Pos> pm;

    public final boolean overlaps(Entity a, Entity b) {
        Bounds b1 = (Bounds)this.bm.get(a);
        Pos p1 = (Pos)this.pm.get(a);
        Bounds b2 = (Bounds)this.bm.get(b);
        Pos p2 = (Pos)this.pm.get(b);
        if (b1 == null || p1 == null || b2 == null || p2 == null) {
            return false;
        }
        float minx = p1.xy.x + b1.minx;
        float miny = p1.xy.y + b1.miny;
        float maxx = p1.xy.x + b1.maxx;
        float maxy = p1.xy.y + b1.maxy;
        float bminx = p2.xy.x + b2.minx;
        float bminy = p2.xy.y + b2.miny;
        float bmaxx = p2.xy.x + b2.maxx;
        float bmaxy = p2.xy.y + b2.maxy;
        return !(minx > bmaxx || maxx < bminx || miny > bmaxy || maxy < bminy);
    }

    protected void processSystem() {
    }
}

