/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.physics;

import com.artemis.Aspect;
import com.artemis.ComponentMapper;
import com.artemis.annotations.Wire;
import com.artemis.systems.IteratingSystem;
import com.badlogic.gdx.math.MathUtils;
import net.mostlyoriginal.api.component.basic.Bounds;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.physics.Clamped;
import net.mostlyoriginal.api.component.physics.Physics;

@Wire(injectInherited=true)
public class ClampedSystem
extends IteratingSystem {
    private ComponentMapper<Pos> pm;
    private ComponentMapper<Bounds> bm;
    private ComponentMapper<Clamped> cm;
    private ComponentMapper<Physics> ym;

    public ClampedSystem() {
        super(Aspect.all((Class[])new Class[]{Pos.class, Clamped.class}));
    }

    protected void process(int e) {
        Pos pos = (Pos)this.pm.get(e);
        Bounds bounds = this.bm.has(e) ? (Bounds)this.bm.get(e) : Bounds.NONE;
        Clamped clamped = (Clamped)this.cm.get(e);
        float wx1 = clamped.minx - bounds.minx;
        float wx2 = clamped.maxx - bounds.maxx;
        float wy1 = clamped.miny - bounds.miny;
        float wy2 = clamped.maxy - bounds.maxy;
        if (this.ym.has(e)) {
            Physics physics = (Physics)this.ym.get(e);
            if (physics.vx < 0.0f && pos.xy.x + physics.vx * this.world.delta <= wx1) {
                physics.vx = 0.0f;
            }
            if (physics.vx > 0.0f && pos.xy.x + physics.vx * this.world.delta >= wx2) {
                physics.vx = 0.0f;
            }
            if (physics.vy < 0.0f && pos.xy.y + physics.vy * this.world.delta <= wy1) {
                physics.vy = 0.0f;
            }
            if (physics.vy > 0.0f && pos.xy.y + physics.vy * this.world.delta >= wy2) {
                physics.vy = 0.0f;
            }
        }
        pos.xy.x = MathUtils.clamp((float)pos.xy.x, (float)wx1, (float)wx2);
        pos.xy.y = MathUtils.clamp((float)pos.xy.y, (float)wy1, (float)wy2);
    }
}

