/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.physics;

import com.artemis.Aspect;
import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.artemis.annotations.Wire;
import com.artemis.systems.IteratingSystem;
import com.badlogic.gdx.math.Vector2;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.physics.Attached;

@Wire
public class AttachmentSystem
extends IteratingSystem {
    private ComponentMapper<Pos> pm;
    private ComponentMapper<Attached> am;
    Vector2 vTmp = new Vector2();

    public AttachmentSystem() {
        super(Aspect.all((Class[])new Class[]{Pos.class, Attached.class}));
    }

    protected void process(int e) {
        Attached attached = (Attached)this.am.get(e);
        int parent = attached.parent;
        if (parent != -1) {
            Pos pos = (Pos)this.pm.get(e);
            Pos parPos = (Pos)this.pm.get(parent);
            pos.xy.x = parPos.xy.x + (float)attached.xo + attached.slackX;
            pos.xy.y = parPos.xy.y + (float)attached.yo + attached.slackY;
            this.updateSlack(attached);
        } else {
            this.world.delete(e);
        }
    }

    public void push(Entity entity, float rotation, float force) {
        if (this.am.has(entity)) {
            this.push((Attached)this.am.get(entity), rotation, force);
        }
    }

    public void push(Attached attached, float rotation, float force) {
        this.vTmp.set(force, 0.0f).rotate(rotation).add(attached.slackX, attached.slackY).clamp(0.0f, attached.maxSlack);
        attached.slackX = this.vTmp.x;
        attached.slackY = this.vTmp.y;
    }

    protected void updateSlack(Attached attached) {
        float len = this.vTmp.set(attached.slackX, attached.slackY).len() - this.world.delta * attached.tension;
        if (len > 0.0f) {
            this.vTmp.nor().scl(len);
        } else {
            this.vTmp.set(0.0f, 0.0f);
        }
        attached.slackX = this.vTmp.x;
        attached.slackY = this.vTmp.y;
    }
}

