/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.map;

import com.artemis.BaseSystem;
import com.artemis.annotations.Wire;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.utils.Array;
import net.mostlyoriginal.api.manager.AbstractEntityFactorySystem;
import net.mostlyoriginal.api.utils.MapMask;

@Wire
public class TiledMapSystem
extends BaseSystem {
    private final String mapFilename;
    private AbstractEntityFactorySystem entityFactorySystem;
    public TiledMap map;
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private boolean isSetup;
    public Array<TiledMapTileLayer> layers;

    public TiledMapSystem(String mapFilename) {
        this.mapFilename = mapFilename;
    }

    protected void initialize() {
        this.map = new TmxMapLoader().load(this.mapFilename);
        this.layers = this.map.getLayers().getByType(TiledMapTileLayer.class);
        this.width = (Integer)this.map.getProperties().get("width", Integer.class);
        this.height = (Integer)this.map.getProperties().get("height", Integer.class);
        this.tileWidth = (Integer)this.map.getProperties().get("tilewidth", Integer.class);
        this.tileHeight = (Integer)this.map.getProperties().get("tileheight", Integer.class);
    }

    public MapMask getMask(String property) {
        return new MapMask(this.height, this.width, this.tileWidth, this.tileHeight, this.layers, property);
    }

    protected void setup() {
        for (TiledMapTileLayer layer : this.layers) {
            for (int ty = 0; ty < this.height; ++ty) {
                for (int tx = 0; tx < this.width; ++tx) {
                    MapProperties properties;
                    TiledMapTileLayer.Cell cell = layer.getCell(tx, ty);
                    if (cell == null || !(properties = cell.getTile().getProperties()).containsKey("entity")) continue;
                    this.entityFactorySystem.createEntity((String)properties.get("entity"), tx * this.tileWidth, ty * this.tileHeight, properties);
                    layer.setCell(tx, ty, null);
                }
            }
        }
    }

    protected void processSystem() {
        if (!this.isSetup) {
            this.isSetup = true;
            this.setup();
        }
    }
}

