/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.map;

import com.artemis.Aspect;
import com.artemis.ComponentMapper;
import com.artemis.annotations.Wire;
import com.artemis.systems.IteratingSystem;
import net.mostlyoriginal.api.component.basic.Bounds;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.map.MapWallSensor;
import net.mostlyoriginal.api.component.physics.Physics;
import net.mostlyoriginal.api.system.map.TiledMapSystem;
import net.mostlyoriginal.api.utils.MapMask;

@Wire
public class MapWallSensorSystem
extends IteratingSystem {
    public static final String MASK_SOLID_ID = "solid";
    private TiledMapSystem mapSystem;
    private boolean initialized;
    private MapMask solidMask;
    private ComponentMapper<Physics> ym;
    private ComponentMapper<Pos> pm;
    private ComponentMapper<Bounds> bm;
    private ComponentMapper<MapWallSensor> ws;

    public MapWallSensorSystem() {
        super(Aspect.all((Class[])new Class[]{MapWallSensor.class, Pos.class, Bounds.class}));
    }

    protected void begin() {
        if (!this.initialized) {
            this.initialized = true;
            this.solidMask = this.mapSystem.getMask(MASK_SOLID_ID);
        }
    }

    protected void end() {
    }

    protected void process(int e) {
        Pos pos = (Pos)this.pm.get(e);
        Bounds bounds = (Bounds)this.bm.get(e);
        float px = pos.xy.x;
        float py = pos.xy.y;
        MapWallSensor mapWallSensor = (MapWallSensor)this.ws.get(e);
        boolean onFloor = this.collides(px + bounds.minx + (bounds.maxx - bounds.minx) * 0.5f, py + bounds.miny - 1.0f) || this.collides(px + bounds.minx + (bounds.maxx - bounds.minx) * 0.5f, py + bounds.miny - 2.0f);
        boolean onCeiling = this.collides(px + bounds.minx + (bounds.maxx - bounds.minx) * 0.5f, py + bounds.maxy + 1.0f);
        boolean onEastWall = this.collides(px + bounds.maxx + 1.0f, py + bounds.miny + (bounds.maxy - bounds.miny) * 0.5f);
        boolean onWestWall = this.collides(px + bounds.minx - 1.0f, py + bounds.miny + (bounds.maxy - bounds.miny) * 0.5f);
        mapWallSensor.onVerticalSurface = onEastWall || onWestWall;
        mapWallSensor.onFloor = onFloor;
        boolean bl = mapWallSensor.onHorizontalSurface = onCeiling || mapWallSensor.onFloor;
        mapWallSensor.wallAngle = onFloor ? 90.0f : (onCeiling ? -90.0f : (onEastWall ? 0.0f : (onWestWall ? 180.0f : 90.0f)));
    }

    private boolean collides(float x, float y) {
        return this.solidMask.atScreen(x, y, true);
    }
}

