/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.map;

import com.artemis.Aspect;
import com.artemis.ComponentMapper;
import com.artemis.annotations.Wire;
import com.artemis.systems.IteratingSystem;
import net.mostlyoriginal.api.component.basic.Bounds;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.map.MapSolid;
import net.mostlyoriginal.api.component.physics.Physics;
import net.mostlyoriginal.api.system.camera.CameraSystem;
import net.mostlyoriginal.api.system.map.TiledMapSystem;
import net.mostlyoriginal.api.utils.MapMask;

@Wire
public class MapCollisionSystem
extends IteratingSystem {
    private TiledMapSystem mapSystem;
    private CameraSystem cameraSystem;
    private boolean initialized;
    private MapMask solidMask;
    private ComponentMapper<Physics> ym;
    private ComponentMapper<Pos> pm;
    private ComponentMapper<Bounds> bm;

    public MapCollisionSystem() {
        super(Aspect.all((Class[])new Class[]{Physics.class, Pos.class, Bounds.class, MapSolid.class}));
    }

    protected void begin() {
        if (!this.initialized) {
            this.initialized = true;
            this.solidMask = this.mapSystem.getMask("solid");
        }
    }

    protected void end() {
    }

    protected void process(int e) {
        Physics physics = (Physics)this.ym.get(e);
        Pos pos = (Pos)this.pm.get(e);
        Bounds bounds = (Bounds)this.bm.get(e);
        if (physics.vx != 0.0f || physics.vy != 0.0f) {
            float px = pos.xy.x + physics.vx * this.world.delta;
            float py = pos.xy.y + physics.vy * this.world.delta;
            if (physics.vx > 0.0f && this.collides(px + bounds.maxx, py + bounds.miny + (bounds.maxy - bounds.miny) * 0.5f) || physics.vx < 0.0f && this.collides(px + bounds.minx, py + bounds.miny + (bounds.maxy - bounds.miny) * 0.5f)) {
                physics.vx = physics.bounce > 0.0f ? -physics.vx * physics.bounce : 0.0f;
                px = pos.xy.x;
            }
            if (physics.vy > 0.0f && this.collides(px + bounds.minx + (bounds.maxx - bounds.minx) * 0.5f, py + bounds.maxy) || physics.vy < 0.0f && this.collides(px + bounds.minx + (bounds.maxx - bounds.minx) * 0.5f, py + bounds.miny)) {
                physics.vy = physics.bounce > 0.0f ? -physics.vy * physics.bounce : 0.0f;
            }
        }
    }

    private boolean collides(float x, float y) {
        return this.solidMask.atScreen(x, y, true);
    }
}

