/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.graphics;

import com.artemis.BaseSystem;
import com.artemis.ComponentMapper;
import com.artemis.World;
import com.artemis.annotations.Wire;
import com.artemis.utils.Bag;
import net.mostlyoriginal.api.component.graphics.Render;
import net.mostlyoriginal.api.system.delegate.EntityProcessAgent;
import net.mostlyoriginal.api.system.delegate.EntityProcessPrincipal;
import net.mostlyoriginal.api.utils.BagUtils;

@Wire
public class RenderBatchingSystem
extends BaseSystem
implements EntityProcessPrincipal {
    protected ComponentMapper<Render> mRenderable;
    protected final Bag<Job> sortedJobs = new Bag();
    public boolean sortedDirty = false;

    protected void setWorld(World world) {
        super.setWorld(world);
    }

    public void registerAgent(int entityId, EntityProcessAgent agent) {
        if (!this.mRenderable.has(entityId)) {
            throw new RuntimeException("RenderBatchingSystem requires agents entities to have component Renderable.");
        }
        this.sortedJobs.add((Object)new Job(entityId, agent));
        this.sortedDirty = true;
    }

    public void unregisterAgent(int entityId, EntityProcessAgent agent) {
        Object[] data = this.sortedJobs.getData();
        int s = this.sortedJobs.size();
        for (int i = 0; i < s; ++i) {
            Job e2 = (Job)data[i];
            if (e2.entityId != entityId || e2.agent != agent) continue;
            this.sortedJobs.remove(i);
            this.sortedDirty = true;
            break;
        }
    }

    protected void processSystem() {
        if (this.sortedDirty) {
            this.sortedDirty = false;
            BagUtils.sort(this.sortedJobs);
        }
        EntityProcessAgent activeAgent = null;
        Object[] data = this.sortedJobs.getData();
        int s = this.sortedJobs.size();
        for (int i = 0; i < s; ++i) {
            Job job = (Job)data[i];
            EntityProcessAgent agent = job.agent;
            if (agent != activeAgent) {
                if (activeAgent != null) {
                    activeAgent.end();
                }
                activeAgent = agent;
                activeAgent.begin();
            }
            agent.process(job.entityId);
        }
        if (activeAgent != null) {
            activeAgent.end();
        }
    }

    protected boolean checkProcessing() {
        return true;
    }

    public class Job
    implements Comparable<Job> {
        public final int entityId;
        public final EntityProcessAgent agent;

        public Job(int entityId, EntityProcessAgent agent) {
            this.entityId = entityId;
            this.agent = agent;
        }

        @Override
        public int compareTo(Job o) {
            return ((Render)RenderBatchingSystem.this.mRenderable.get((int)this.entityId)).layer - ((Render)RenderBatchingSystem.this.mRenderable.get((int)o.entityId)).layer;
        }
    }
}

