/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.camera;

import com.artemis.BaseSystem;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;

public class CameraSystem
extends BaseSystem {
    public OrthographicCamera camera;
    public OrthographicCamera guiCamera;
    public final float zoom;

    public CameraSystem(float width, float height) {
        this.zoom = 1.0f;
        this.setupViewport(width, height);
    }

    public CameraSystem(float zoom) {
        this.zoom = zoom;
        float zoomFactorInverter = 1.0f / zoom;
        this.setupViewport((float)Gdx.graphics.getWidth() * zoomFactorInverter, (float)Gdx.graphics.getHeight() * zoomFactorInverter);
    }

    protected void setupViewport(float width, float height) {
        this.camera = new OrthographicCamera(width, height);
        this.camera.setToOrtho(false, width, height);
        this.camera.update();
        this.guiCamera = new OrthographicCamera(width, height);
        this.guiCamera.setToOrtho(false, width, height);
        this.guiCamera.update();
    }

    protected void processSystem() {
    }
}

