/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.camera;

import com.artemis.BaseSystem;
import com.artemis.annotations.Wire;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import net.mostlyoriginal.api.system.camera.CameraSystem;

@Wire
public class CameraShakeSystem
extends BaseSystem {
    public CameraSystem cameraSystem;
    public float shake = 0.0f;
    public Vector2 push = new Vector2();

    public void shake(float pixels) {
        this.shake = pixels;
    }

    public void push(float x, float y) {
        this.push.x = x;
        this.push.y = y;
    }

    protected void processSystem() {
        OrthographicCamera camera = this.cameraSystem.camera;
        if (this.shake != 0.0f) {
            camera.position.x = (int)(camera.position.x + MathUtils.random((float)this.push.x) + (this.shake != 0.0f ? MathUtils.random((float)(-this.shake), (float)this.shake) : 0.0f));
            camera.position.y = (int)(camera.position.y + MathUtils.random((float)this.push.y) + (this.shake != 0.0f ? MathUtils.random((float)(-this.shake), (float)this.shake) : 0.0f));
            camera.update();
            if (this.shake > 0.0f) {
                this.shake -= this.world.delta * 4.0f;
                if (this.shake < 0.0f) {
                    this.shake = 0.0f;
                }
            }
            this.decrease(this.push, this.world.delta * 16.0f);
        }
    }

    private void decrease(Vector2 v, float delta) {
        if (v.x > 0.0f) {
            v.x -= delta;
            if (v.x < 0.0f) {
                v.x = 0.0f;
            }
        }
        if (v.x < 0.0f) {
            v.x += delta;
            if (v.x > 0.0f) {
                v.x = 0.0f;
            }
        }
        if (v.y > 0.0f) {
            v.y -= delta;
            if (v.y < 0.0f) {
                v.y = 0.0f;
            }
        }
        if (v.y < 0.0f) {
            v.y += delta;
            if (v.y > 0.0f) {
                v.y = 0.0f;
            }
        }
    }
}

