/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.screen.core;

import com.artemis.World;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.math.MathUtils;

public abstract class WorldScreen
implements Screen {
    public static final float MIN_DELTA = 0.06666667f;
    protected World world;

    protected abstract World createWorld();

    public void show() {
        if (this.world == null) {
            this.world = this.createWorld();
        }
    }

    public void render(float delta) {
        if (this.world == null) {
            throw new RuntimeException("World not initialized.");
        }
        this.world.setDelta(MathUtils.clamp((float)delta, (float)0.0f, (float)0.06666667f));
        this.world.process();
    }

    public void resize(int width, int height) {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void hide() {
    }

    public void dispose() {
    }
}

