/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.operation;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import net.mostlyoriginal.api.component.basic.Pos;
import net.mostlyoriginal.api.component.basic.Scale;
import net.mostlyoriginal.api.component.graphics.Tint;
import net.mostlyoriginal.api.operation.SetPosOperation;
import net.mostlyoriginal.api.operation.SetScaleOperation;
import net.mostlyoriginal.api.operation.SetTintOperation;
import net.mostlyoriginal.api.operation.TweenPosOperation;
import net.mostlyoriginal.api.operation.TweenScaleOperation;
import net.mostlyoriginal.api.operation.TweenTintOperation;
import net.mostlyoriginal.api.operation.common.Operation;
import net.mostlyoriginal.api.operation.temporal.TweenOperation;

public class JamOperationFactory {
    private static Tint fromTmp = new Tint();
    private static Tint toTmp = new Tint();

    private JamOperationFactory() {
    }

    public static TweenPosOperation moveBetween(float x1, float y1, float x2, float y2, float duration) {
        return JamOperationFactory.moveBetween(x1, y1, x2, y2, duration, Interpolation.linear);
    }

    public static TweenPosOperation moveBetween(Vector2 from, Vector2 to, float duration) {
        return JamOperationFactory.moveBetween(from, to, duration, Interpolation.linear);
    }

    public static TweenPosOperation moveBetween(Pos from, Pos to, float duration) {
        return JamOperationFactory.moveBetween(from, to, duration, Interpolation.linear);
    }

    public static TweenPosOperation moveBetween(float x1, float y1, float x2, float y2, float duration, Interpolation interpolation) {
        TweenPosOperation operation = (TweenPosOperation)Operation.prepare(TweenPosOperation.class);
        operation.setup(interpolation, duration);
        ((Pos)operation.getFrom()).set(x1, y1);
        ((Pos)operation.getTo()).set(x2, y2);
        return operation;
    }

    public static TweenPosOperation moveBetween(Vector2 from, Vector2 to, float duration, Interpolation interpolation) {
        return JamOperationFactory.moveBetween(from.x, from.y, to.x, to.y, duration, interpolation);
    }

    public static TweenPosOperation moveBetween(Pos from, Pos to, float duration, Interpolation interpolation) {
        return JamOperationFactory.moveBetween(from.xy.x, from.xy.y, to.xy.x, to.xy.y, duration, interpolation);
    }

    public static SetPosOperation moveTo(float x, float y) {
        SetPosOperation operation = (SetPosOperation)Operation.prepare(SetPosOperation.class);
        ((Pos)operation.get()).set(x, y);
        return operation;
    }

    public static SetPosOperation moveTo(Pos pos) {
        return JamOperationFactory.moveTo(pos.xy.x, pos.xy.y);
    }

    public static SetPosOperation moveTo(Vector2 v) {
        return JamOperationFactory.moveTo(v.x, v.y);
    }

    public static TweenScaleOperation scaleBetween(float from, float to, float duration, Interpolation interpolation) {
        TweenScaleOperation operation = (TweenScaleOperation)Operation.prepare(TweenScaleOperation.class);
        operation.setup(interpolation, duration);
        ((Scale)operation.getFrom()).scale = from;
        ((Scale)operation.getTo()).scale = to;
        return operation;
    }

    public static TweenScaleOperation scaleBetween(float from, float to, float duration) {
        return JamOperationFactory.scaleBetween(from, to, duration, Interpolation.linear);
    }

    public static SetScaleOperation scaleTo(float scale) {
        SetScaleOperation operation = (SetScaleOperation)Operation.prepare(SetScaleOperation.class);
        ((Scale)operation.get()).scale = scale;
        return operation;
    }

    public static SetTintOperation tintTo(Tint to) {
        SetTintOperation operation = (SetTintOperation)Operation.prepare(SetTintOperation.class);
        ((Tint)operation.get()).set(to);
        return operation;
    }

    public static TweenTintOperation tintBetween(Tint from, Tint to, float duration) {
        return JamOperationFactory.tintBetween(from, to, duration, Interpolation.linear);
    }

    public static TweenTintOperation tintBetween(Tint from, Tint to, float duration, Interpolation interpolation) {
        TweenTintOperation operation = JamOperationFactory.prepTween(TweenTintOperation.class, duration, interpolation);
        ((Tint)operation.getFrom()).set(from);
        ((Tint)operation.getTo()).set(to);
        return operation;
    }

    private static <T extends TweenOperation> T prepTween(Class<T> operationType, float duration, Interpolation interpolation) {
        TweenOperation operation = (TweenOperation)Operation.prepare(operationType);
        operation.setup(interpolation, duration);
        return (T)operation;
    }
}

