/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.manager;

import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import net.mostlyoriginal.api.component.basic.Size;
import net.mostlyoriginal.api.component.graphics.Terrain;
import net.mostlyoriginal.api.component.graphics.TerrainAsset;
import net.mostlyoriginal.api.manager.AssetManager;

public class TerrainManager
extends AssetManager<Terrain, TerrainAsset> {
    protected ComponentMapper<Size> mSize;
    private TmxMapLoader loader;

    public TerrainManager() {
        super(Terrain.class, TerrainAsset.class);
    }

    protected void initialize() {
        super.initialize();
        this.loader = new TmxMapLoader();
    }

    protected void setup(Entity e, Terrain terrain, TerrainAsset asset) {
        if (terrain.id == null) {
            throw new RuntimeException("TerrainManager: terrain.id is null.");
        }
        asset.map = this.loader.load(terrain.id);
        asset.renderer = new OrthogonalTiledMapRenderer(asset.map);
        MapProperties properties = asset.map.getProperties();
        asset.width = (Integer)properties.get("width", Integer.class);
        asset.height = (Integer)properties.get("height", Integer.class);
        asset.tileWidth = (Integer)properties.get("tilewidth", Integer.class);
        asset.tileHeight = (Integer)properties.get("tileheight", Integer.class);
        if (!this.mSize.has(e)) {
            ((Size)this.mSize.create(e)).set(asset.pixelWidth(), asset.pixelHeight());
        }
    }
}

