/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.manager;

import com.artemis.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.utils.ObjectMap;
import net.mostlyoriginal.api.component.ui.BitmapFontAsset;
import net.mostlyoriginal.api.component.ui.Font;
import net.mostlyoriginal.api.manager.AssetManager;

public class FontManager
extends AssetManager<Font, BitmapFontAsset> {
    private final ObjectMap<String, BitmapFont> fonts = new ObjectMap();

    public FontManager() {
        super(Font.class, BitmapFontAsset.class);
    }

    protected void setup(Entity entity, Font font, BitmapFontAsset bitmapFontAsset) {
        if (font.fontName == null) {
            throw new RuntimeException("FontManager: font.fontName is null.");
        }
        bitmapFontAsset.bitmapFont = this.getFont(font.fontName);
    }

    public BitmapFont getFont(String fontName) {
        BitmapFont font = (BitmapFont)this.fonts.get((Object)fontName);
        if (font == null) {
            font = this.loadFont(fontName);
            this.fonts.put((Object)fontName, (Object)font);
        }
        return font;
    }

    private BitmapFont loadFont(String fontName) {
        return new BitmapFont(Gdx.files.internal(fontName + ".fnt"), false);
    }
}

