/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.manager;

import com.artemis.BaseSystem;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import java.util.HashMap;

public class AbstractAssetSystem
extends BaseSystem {
    public Texture tileset;
    public HashMap<String, Animation> sprites = new HashMap();
    public HashMap<String, Sound> sounds = new HashMap();
    protected float sfxVolume = 0.2f;

    public AbstractAssetSystem() {
        this("tiles.png");
    }

    public AbstractAssetSystem(String filename) {
        this.tileset = new Texture(filename);
    }

    public Animation get(String identifier) {
        return this.sprites.get(identifier);
    }

    public Sound getSfx(String identifier) {
        return this.sounds.get(identifier);
    }

    public Animation add(String identifier, int x1, int y1, int w, int h, int repeatX) {
        return this.add(identifier, x1, y1, w, h, repeatX, 1, this.tileset);
    }

    public Animation add(String identifier, int x1, int y1, int w, int h, int repeatX, int repeatY) {
        return this.add(identifier, x1, y1, w, h, repeatX, repeatY, this.tileset);
    }

    public Animation add(String identifier, int x1, int y1, int w, int h, int repeatX, int repeatY, Texture texture) {
        return this.add(identifier, x1, y1, w, h, repeatX, repeatY, this.tileset, 0.5f);
    }

    public Animation add(String identifier, int x1, int y1, int w, int h, int repeatX, int repeatY, Texture texture, float frameDuration) {
        Object[] regions = new TextureRegion[repeatX * repeatY];
        int count = 0;
        for (int y = 0; y < repeatY; ++y) {
            for (int x = 0; x < repeatX; ++x) {
                regions[count++] = new TextureRegion(texture, x1 + w * x, y1 + h * y, w, h);
            }
        }
        Animation value = new Animation(frameDuration, regions);
        this.sprites.put(identifier, value);
        return value;
    }

    protected void processSystem() {
    }

    protected void loadSounds(String[] soundnames) {
        for (String identifier : soundnames) {
            this.sounds.put(identifier, Gdx.audio.newSound(Gdx.files.internal("sfx/" + identifier + ".mp3")));
        }
    }

    public void playSfx(String name) {
        Sound sfx;
        if (this.sfxVolume > 0.0f && (sfx = this.getSfx(name)) != null) {
            sfx.stop();
            sfx.play(this.sfxVolume, MathUtils.random((float)1.0f, (float)1.04f), 0.0f);
        }
    }

    public void dispose() {
        this.sprites.clear();
        this.tileset.dispose();
        this.tileset = null;
    }
}

