/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.component.graphics;

import com.artemis.annotations.Fluid;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import net.mostlyoriginal.api.component.common.ExtendedComponent;
import net.mostlyoriginal.api.component.common.Tweenable;

@Fluid(swallowGettersWithParameters=true)
public class Tint
extends ExtendedComponent<Tint>
implements Tweenable<Tint> {
    public static final Tint WHITE = new Tint(Color.WHITE);
    public static final Tint TRANSPARENT = new Tint("ffffff00");
    public Color color = new Color();

    public Tint() {
    }

    public Tint(Color color) {
        this.set(color);
    }

    public Tint(Tint tint) {
        this.set(tint);
    }

    public Tint(float r, float g, float b, float a) {
        this.set(r, g, b, a);
    }

    protected void reset() {
        this.color.set(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Tint(String hex) {
        this.setHex(hex);
    }

    public void setHex(String hex) {
        this.set((float)Integer.valueOf(hex.substring(0, 2), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(2, 4), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(4, 6), 16).intValue() / 255.0f, (float)(hex.length() != 8 ? 255 : Integer.valueOf(hex.substring(6, 8), 16)) / 255.0f);
    }

    public void set(Color color) {
        this.color.set(color);
    }

    public void set(float r, float g, float b, float a) {
        this.color.r = r;
        this.color.g = g;
        this.color.b = b;
        this.color.a = a;
    }

    public void set(Tint tint) {
        this.color.r = tint.color.r;
        this.color.g = tint.color.g;
        this.color.b = tint.color.b;
        this.color.a = tint.color.a;
    }

    public void tween(Tint a, Tint b, float value) {
        Interpolation linear = Interpolation.linear;
        Color colorA = a.color;
        Color colorB = b.color;
        this.color.r = linear.apply(colorA.r, colorB.r, value);
        this.color.g = linear.apply(colorA.g, colorB.g, value);
        this.color.b = linear.apply(colorA.b, colorB.b, value);
        this.color.a = linear.apply(colorA.a, colorB.a, value);
    }
}

