/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.config.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.morimekta.config.SecretsManager;

public class SecretValueDeserializer
extends StdDeserializer<String> {
    public SecretValueDeserializer() {
        super(String.class);
    }

    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (Objects.requireNonNull(jsonParser.currentToken()) == JsonToken.VALUE_STRING) {
            String value = jsonParser.getValueAsString();
            try {
                if (value.startsWith("${") && value.endsWith("}")) {
                    SecretsManager manager = (SecretsManager)deserializationContext.getAttribute(SecretsManager.class);
                    String secretName = value.substring(2, value.length() - 1).trim();
                    if (manager != null && manager.exists(secretName)) {
                        return manager.get(secretName).getAsString();
                    }
                    String envValue = System.getenv(secretName);
                    if (envValue == null || envValue.isEmpty()) {
                        throw new JsonParseException(jsonParser, "Unknown secret '" + secretName + "'", jsonParser.currentTokenLocation());
                    }
                    return envValue;
                }
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new JsonParseException(jsonParser, e.getMessage(), jsonParser.currentTokenLocation(), (Throwable)e);
            }
            catch (NoSuchElementException e) {
                throw new JsonParseException(jsonParser, "Unknown secret " + value, jsonParser.currentTokenLocation(), (Throwable)e);
            }
        }
        return this._parseString(jsonParser, deserializationContext, (NullValueProvider)this);
    }
}

