/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.config.readers;

import java.nio.file.Path;
import java.util.Optional;
import java.util.ServiceLoader;
import net.morimekta.collect.util.LazyCachedSupplier;
import net.morimekta.config.ConfigException;
import net.morimekta.config.readers.ConfigReader;
import net.morimekta.config.readers.ConfigReaderProvider;
import net.morimekta.config.readers.ConfigReaderSupplier;

public final class ProvidedConfigReaderSupplier<ConfigType>
implements ConfigReaderSupplier<ConfigType> {
    private final Class<ConfigType> configType;
    private static final LazyCachedSupplier<ServiceLoader<ConfigReaderProvider>> kServiceLoader = new LazyCachedSupplier(() -> ServiceLoader.load(ConfigReaderProvider.class));

    public ProvidedConfigReaderSupplier(Class<ConfigType> configType) {
        this.configType = configType;
    }

    @Override
    public ConfigReader<ConfigType> getReaderFor(Path file) throws ConfigException {
        for (ConfigReaderProvider provider : (ServiceLoader)kServiceLoader.get()) {
            Optional<ConfigReader<ConfigType>> reader = provider.getReaderFor(this.configType, file);
            if (!reader.isPresent()) continue;
            return reader.get();
        }
        throw new ConfigException("No config reader available for " + file.getFileName() + " of type " + this.configType.getName());
    }
}

