/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.config.readers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.function.Consumer;
import net.morimekta.config.ConfigException;
import net.morimekta.config.readers.ConfigReader;
import net.morimekta.file.FileUtil;

public class YamlConfigReader<ConfigType>
implements ConfigReader<ConfigType> {
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final Class<ConfigType> configType;

    public YamlConfigReader(Class<ConfigType> configType) {
        this(configType, ObjectMapper::findAndRegisterModules);
    }

    public YamlConfigReader(Class<ConfigType> configType, Consumer<ObjectMapper> init) {
        this.configType = configType;
        init.accept(this.mapper);
    }

    /*
     * Loose catch block
     */
    @Override
    public ConfigType readConfig(Path file) throws IOException, ConfigException {
        Path canonical = FileUtil.readCanonicalPath((Path)Objects.requireNonNull(file, "file == null"));
        if (!Files.exists(canonical, new LinkOption[0])) {
            throw new FileNotFoundException("No such config file " + file);
        }
        if (!Files.isRegularFile(canonical, new LinkOption[0])) {
            throw new IOException("Config path " + file + " is not a regular file.");
        }
        try (InputStream in = Files.newInputStream(canonical, StandardOpenOption.READ);){
            Object object;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                object = this.mapper.readValue((Reader)reader, this.configType);
            }
            return (ConfigType)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }
}

