/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.morimekta.collect.util.Binary;
import net.morimekta.config.ConfigWatcher;
import net.morimekta.config.Secret;
import net.morimekta.file.FileEvent;
import net.morimekta.file.FileEventListener;
import net.morimekta.file.FileUtil;
import net.morimekta.file.FileWatcher;
import net.morimekta.strings.EscapeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=SecretManagerDeserializer.class)
public class SecretsManager
implements Closeable {
    private final Map<String, Secret> secrets;
    private final Path secretsDir;
    private final FileWatcher fileWatcher;
    private final FileEventListener fileEventListener;
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretsManager.class);

    public SecretsManager(Path secretsDir) throws IOException {
        this(secretsDir, ConfigWatcher.FILE_WATCHER.get());
    }

    public SecretsManager(Path secretsDir, FileWatcher fileWatcher) throws IOException {
        Objects.requireNonNull(secretsDir, "secretsDir == null");
        Objects.requireNonNull(fileWatcher, "fileWatcher == null");
        if (!Files.isDirectory(secretsDir, new LinkOption[0])) {
            throw new IOException("Secrets location \"" + secretsDir + "\" not a directory.");
        }
        this.secrets = new ConcurrentHashMap<String, Secret>();
        this.secretsDir = secretsDir;
        this.fileWatcher = fileWatcher;
        this.fileEventListener = this::onFileEvent;
    }

    @JsonValue
    public Path getSecretsPath() {
        return this.secretsDir;
    }

    @JsonIgnore
    public boolean exists(String name) {
        Objects.requireNonNull(name, "name == null");
        if (name.isBlank()) {
            throw new IllegalArgumentException("Empty secret name.");
        }
        if (name.startsWith(".") || name.contains(File.separator)) {
            throw new IllegalArgumentException("Hidden file or path in name, not allowed: \"" + EscapeUtil.javaEscape((CharSequence)name) + "\".");
        }
        try {
            Path path = this.secretsDir.resolve(name);
            if (Files.isSymbolicLink(path)) {
                return Files.isRegularFile(FileUtil.readCanonicalPath((Path)path), new LinkOption[0]);
            }
            return Files.isRegularFile(path, new LinkOption[0]);
        }
        catch (IOException e) {
            return false;
        }
    }

    @JsonIgnore
    public Set<String> getKnownSecrets() {
        try {
            return FileUtil.list((Path)this.getSecretsPath()).stream().map(Path::getFileName).map(Path::toString).filter(name -> !name.startsWith(".")).collect(Collectors.toSet());
        }
        catch (IOException e) {
            return Set.of();
        }
    }

    @JsonIgnore
    public String getAsString(String name) {
        return this.get(name).getAsString();
    }

    @JsonIgnore
    public byte[] getAsBytes(String name) {
        return this.get(name).getAsBytes();
    }

    @JsonIgnore
    public Binary getAsBinary(String name) {
        return this.get(name).getAsBinary();
    }

    @JsonIgnore
    public Secret get(String name) {
        Objects.requireNonNull(name, "name == null");
        if (name.isBlank()) {
            throw new IllegalArgumentException("Empty secret name.");
        }
        if (name.startsWith(".") || name.contains(File.separator)) {
            throw new IllegalArgumentException("Hidden file or path in name, not allowed: \"" + EscapeUtil.javaEscape((CharSequence)name) + "\".");
        }
        Path path = this.secretsDir.resolve(name);
        if (!Files.exists(path, new LinkOption[0])) {
            if (!Files.exists(this.secretsDir, new LinkOption[0])) {
                throw new IllegalStateException("Secrets directory deleted: \"" + this.secretsDir + "\".");
            }
            throw new NoSuchElementException("No secret file for name \"" + name + "\".");
        }
        return this.secrets.computeIfAbsent(name, k -> {
            Secret secret = new Secret(name, false, SecretsManager.readSecret(name, path));
            this.fileWatcher.weakAddWatcher(path, this.fileEventListener);
            return secret;
        });
    }

    @Override
    public void close() {
        this.fileWatcher.removeWatcher(this.fileEventListener);
    }

    public String toString() {
        return "SecretsManager{dir=" + this.secretsDir + "}";
    }

    private void onFileEvent(Path file, FileEvent event) {
        String name = file.getFileName().toString();
        if (event == FileEvent.DELETED) {
            if (Files.exists(file, new LinkOption[0])) {
                return;
            }
            this.secrets.remove(name);
            this.fileWatcher.removeWatcher(file, this.fileEventListener);
            return;
        }
        try {
            Secret secret = this.secrets.get(name);
            if (secret != null) {
                secret.setSecret(SecretsManager.readSecret(name, file));
            } else {
                this.fileWatcher.removeWatcher(file, this.fileEventListener);
            }
        }
        catch (NoSuchElementException e) {
            this.fileWatcher.removeWatcher(file, this.fileEventListener);
        }
    }

    private static Binary readSecret(String name, Path file) {
        Binary binary;
        block9: {
            Path canonical = FileUtil.readCanonicalPath((Path)file);
            if (!Files.isRegularFile(canonical, new LinkOption[0])) {
                throw new NoSuchElementException("Secret " + name + " is not a file.");
            }
            InputStream in = Files.newInputStream(canonical, new OpenOption[0]);
            try {
                binary = Binary.read((InputStream)in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Unable to read secret {}: {}", new Object[]{file, e.getMessage(), e});
                    throw new NoSuchElementException("No secret for " + name + ".");
                }
            }
            in.close();
        }
        return binary;
    }

    private static boolean isTokenType(JsonToken token, JsonToken type) {
        return token.id() == type.id();
    }

    public static class SecretsConfig {
        @JsonProperty(required=true)
        public Path dir;
    }

    public static class SecretManagerDeserializer
    extends JsonDeserializer<SecretsManager> {
        public SecretsManager deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (SecretsManager.isTokenType(jsonParser.currentToken(), JsonToken.VALUE_STRING)) {
                JsonLocation location = jsonParser.currentTokenLocation();
                try {
                    Path path = Paths.get(jsonParser.getValueAsString(), new String[0]);
                    Path canonical = FileUtil.readCanonicalPath((Path)path);
                    SecretsManager manager = new SecretsManager(canonical);
                    deserializationContext.setAttribute(SecretsManager.class, (Object)manager);
                    return manager;
                }
                catch (IOException e) {
                    throw new JsonParseException(jsonParser, e.getMessage(), location, (Throwable)e);
                }
            }
            if (SecretsManager.isTokenType(jsonParser.currentToken(), JsonToken.START_OBJECT)) {
                JsonLocation location = jsonParser.currentTokenLocation();
                try {
                    SecretsConfig config = (SecretsConfig)jsonParser.readValueAs(SecretsConfig.class);
                    Path canonical = FileUtil.readCanonicalPath((Path)config.dir);
                    SecretsManager manager = new SecretsManager(canonical);
                    deserializationContext.setAttribute(SecretsManager.class, (Object)manager);
                    return manager;
                }
                catch (JsonParseException | JsonMappingException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new JsonParseException(jsonParser, e.getMessage(), location, (Throwable)e);
                }
            }
            throw new JsonParseException(jsonParser, "Invalid SecretManager config value: " + jsonParser.getValueAsString() + "\nMust either be a directory path as string, or a config object with a \"dir\" property.", jsonParser.currentTokenLocation());
        }
    }
}

