/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.morimekta.collect.util.LazyCachedSupplier;
import net.morimekta.config.ConfigChangeListener;
import net.morimekta.config.ConfigChangeType;
import net.morimekta.config.ConfigEventListener;
import net.morimekta.config.ConfigException;
import net.morimekta.config.ConfigExceptionBuffer;
import net.morimekta.config.readers.ConfigReader;
import net.morimekta.file.DirWatcher;
import net.morimekta.file.FileEvent;
import net.morimekta.file.FileEventListener;
import net.morimekta.file.FileUtil;
import net.morimekta.file.FileWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigWatcher<ConfigFileType>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigWatcher.class);
    static final Supplier<DirWatcher> DIR_WATCHER = new LazyCachedSupplier(DirWatcher::new);
    static final Supplier<FileWatcher> FILE_WATCHER = new LazyCachedSupplier(() -> new FileWatcher(DIR_WATCHER.get()));
    private final ConfigReader<ConfigFileType> configReader;
    private final Function<ConfigFileType, String> configIdentifier;
    private final List<ConfigEventListener> eventListeners;
    private final List<ConfigChangeListener<ConfigFileType>> changeListeners;
    private final Map<Path, ConfigEntry<ConfigFileType>> loadedConfigMap;
    private final Clock clock;
    private final Path configDir;
    private final Object mutex = new Object();
    private final DirWatcher dirWatcher;
    private final FileWatcher fileWatcher;
    private final FileEventListener fileEventListener;
    private final FileEventListener dirEventListener;

    public ConfigWatcher(Path configDir, ConfigReader<ConfigFileType> configReader, Function<ConfigFileType, String> configIdentifier) {
        this(configDir, configReader, configIdentifier, Clock.systemUTC());
    }

    public ConfigWatcher(Path configDir, ConfigReader<ConfigFileType> configReader, Function<ConfigFileType, String> configIdentifier, Clock clock) {
        this(configDir, configReader, configIdentifier, clock, DIR_WATCHER.get(), FILE_WATCHER.get());
    }

    public ConfigWatcher(Path configDir, ConfigReader<ConfigFileType> configReader, Function<ConfigFileType, String> configIdentifier, Clock clock, DirWatcher dirWatcher, FileWatcher fileWatcher) {
        this.clock = Objects.requireNonNull(clock, "clock == null");
        this.configDir = Objects.requireNonNull(configDir, "configDir == null");
        this.configReader = Objects.requireNonNull(configReader, "configReader == null");
        this.configIdentifier = Objects.requireNonNull(configIdentifier, "configIdentifier == null");
        this.dirWatcher = Objects.requireNonNull(dirWatcher, "dirWatcher == null");
        this.fileWatcher = Objects.requireNonNull(fileWatcher, "fileWatcher == null");
        if (!Files.isDirectory(configDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a directory: " + configDir);
        }
        this.eventListeners = new ArrayList<ConfigEventListener>();
        this.changeListeners = new ArrayList<ConfigChangeListener<ConfigFileType>>();
        this.loadedConfigMap = new HashMap<Path, ConfigEntry<ConfigFileType>>();
        this.dirEventListener = this::onDirectoryEvent;
        this.fileEventListener = this::onFileEvent;
    }

    @JsonProperty(value="configDir")
    public Path getConfigDir() {
        return this.configDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public Map<Path, ConfigEntry<ConfigFileType>> getLoadedConfigMap() {
        Object object = this.mutex;
        synchronized (object) {
            return Map.copyOf(this.loadedConfigMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public ConfigWatcher<ConfigFileType> addEventListener(ConfigEventListener listener) {
        Objects.requireNonNull(listener);
        Object object = this.mutex;
        synchronized (object) {
            this.eventListeners.removeIf(it -> it == listener);
            this.eventListeners.add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public ConfigWatcher<ConfigFileType> addChangeListener(ConfigChangeListener<ConfigFileType> listener) {
        Objects.requireNonNull(listener);
        Object object = this.mutex;
        synchronized (object) {
            this.changeListeners.removeIf(it -> it == listener);
            this.changeListeners.add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public ConfigWatcher<ConfigFileType> start() throws ConfigException {
        Object object = this.mutex;
        synchronized (object) {
            this.dirWatcher.weakAddWatcher(this.configDir, this.dirEventListener);
            ConfigExceptionBuffer ex = new ConfigExceptionBuffer();
            try {
                for (Path file : FileUtil.list((Path)this.configDir)) {
                    try {
                        Path canonical = FileUtil.readCanonicalPath((Path)file);
                        if (Files.isHidden(file) || !Files.isRegularFile(canonical, new LinkOption[0])) continue;
                        this.fileWatcher.weakAddWatcher(file, this.fileEventListener);
                        this.onFileEventInternal(file, FileEvent.CREATED, true);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception handling config file {}", (Object)file.getFileName(), (Object)e);
                        ex.update(e);
                    }
                }
            }
            catch (Exception e) {
                ex.update(e);
            }
            ex.throwIfPresent();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mutex;
        synchronized (object) {
            this.eventListeners.clear();
            this.changeListeners.clear();
            this.dirWatcher.removeWatcher(this.dirEventListener);
            this.fileWatcher.removeWatcher(this.fileEventListener);
        }
    }

    public String toString() {
        return "ConfigWatcher{dir=" + this.configDir + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDirectoryEvent(Path file, FileEvent event) {
        block9: {
            try {
                Path canonical = FileUtil.readCanonicalPath((Path)file);
                if (Files.isHidden(file) || !Files.isRegularFile(canonical, new LinkOption[0])) {
                    return;
                }
                if (event != FileEvent.CREATED) break block9;
                Object object = this.mutex;
                synchronized (object) {
                    this.fileWatcher.weakAddWatcher(file, this.fileEventListener);
                    ConfigFileType config = this.readConfig(event, file, canonical);
                    ConfigEntry<ConfigFileType> old = this.loadedConfigMap.get(file);
                    if (old != null && config.equals(old.config)) {
                        return;
                    }
                    ConfigChangeType change = old == null ? ConfigChangeType.CREATED : ConfigChangeType.MODIFIED;
                    String identifier = this.configIdentifier.apply(config);
                    try {
                        LOGGER.info("{} config for '{}' from {}", new Object[]{change.capitalizedAction(), identifier, file});
                        this.onConfigChange(change, config);
                        this.onConfigFileUpdate(change, file, identifier, ConfigEventListener.Status.OK);
                        this.loadedConfigMap.put(file, new ConfigEntry<ConfigFileType>(file, identifier, this.clock.instant(), config));
                    }
                    catch (Throwable e) {
                        this.onConfigFileUpdate(change, file, identifier, ConfigEventListener.Status.ERROR);
                        LOGGER.error("Failed to update config: {}", (Object)file, (Object)e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to update config: {}", (Object)file, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFileEvent(Path file, FileEvent event) {
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.onFileEventInternal(file, event, false);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to update config: {}", (Object)file, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFileEventInternal(Path file, FileEvent event, boolean rethrow) throws IOException, ConfigException {
        if (event == FileEvent.CREATED || event == FileEvent.MODIFIED) {
            Path canonical = FileUtil.readCanonicalPath((Path)file);
            if (!Files.exists(canonical, new LinkOption[0])) {
                return;
            }
            ConfigFileType config = this.readConfig(this.loadedConfigMap.containsKey(file) ? FileEvent.MODIFIED : FileEvent.CREATED, file, canonical);
            ConfigEntry<ConfigFileType> old = this.loadedConfigMap.get(file);
            if (old != null && config.equals(old.config)) {
                return;
            }
            ConfigChangeType change = old == null ? ConfigChangeType.CREATED : ConfigChangeType.MODIFIED;
            String identifier = this.configIdentifier.apply(config);
            try {
                this.onConfigChange(change, config);
                this.onConfigFileUpdate(change, file, identifier, ConfigEventListener.Status.OK);
                this.loadedConfigMap.put(file, new ConfigEntry<ConfigFileType>(file, identifier, this.clock.instant(), config));
            }
            catch (Exception e) {
                this.onConfigFileUpdate(change, file, identifier, ConfigEventListener.Status.ERROR);
                if (rethrow) {
                    throw ConfigException.asConfigException(e);
                }
                LOGGER.error("{} config for '{}' from {} failed: {}", new Object[]{change.capitalizedAction(), identifier, file, e.getMessage(), e});
            }
        } else if (event == FileEvent.DELETED) {
            if (Files.exists(file, new LinkOption[0])) {
                return;
            }
            ConfigEntry<ConfigFileType> current = this.loadedConfigMap.get(file);
            if (current != null) {
                String identifier = this.configIdentifier.apply(current.config);
                try {
                    this.onConfigFileRead(FileEvent.DELETED, file, ConfigEventListener.Status.OK);
                    this.onConfigChange(ConfigChangeType.DELETED, current.config);
                    this.onConfigFileUpdate(ConfigChangeType.DELETED, file, identifier, ConfigEventListener.Status.OK);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to remove network {} service from config: {}", new Object[]{identifier, file, e});
                    this.onConfigFileUpdate(ConfigChangeType.DELETED, file, identifier, ConfigEventListener.Status.ERROR);
                }
                finally {
                    this.loadedConfigMap.remove(file);
                }
            }
        }
    }

    private ConfigFileType readConfig(FileEvent fileEvent, Path file, Path canonical) throws ConfigException {
        try {
            ConfigFileType config = this.configReader.readConfig(canonical);
            this.onConfigFileRead(fileEvent, file, ConfigEventListener.Status.OK);
            return config;
        }
        catch (ConfigException e) {
            this.onConfigFileRead(fileEvent, file, ConfigEventListener.Status.PARSE_FAILED);
            throw e;
        }
        catch (IOException e) {
            this.onConfigFileRead(fileEvent, file, ConfigEventListener.Status.READ_FAILED);
            throw new ConfigException("Unable to read config: " + e.getMessage(), e);
        }
    }

    private void onConfigChange(ConfigChangeType changeType, ConfigFileType config) throws ConfigException {
        ConfigExceptionBuffer ex = new ConfigExceptionBuffer();
        for (ConfigChangeListener<ConfigFileType> cl : this.changeListeners) {
            try {
                cl.onConfigChange(changeType, config);
            }
            catch (Exception e) {
                ex.update(e);
            }
        }
        ex.throwIfPresent();
    }

    private void onConfigFileRead(FileEvent fileEvent, Path file, ConfigEventListener.Status status) {
        for (ConfigEventListener el : this.eventListeners) {
            try {
                el.onConfigFileRead(fileEvent, file, status);
            }
            catch (Exception e) {
                LOGGER.warn("Exception in config event listener: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void onConfigFileUpdate(ConfigChangeType changeType, Path file, String identifier, ConfigEventListener.Status status) {
        for (ConfigEventListener el : this.eventListeners) {
            try {
                el.onConfigFileUpdate(changeType, file, identifier, status);
            }
            catch (Exception e) {
                LOGGER.warn("Exception in config event listener: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static class ConfigEntry<ConfigFileType> {
        public final Path file;
        public final String identifier;
        public final Instant updatedAt;
        public final ConfigFileType config;

        public ConfigEntry(Path file, String identifier, Instant updatedAt, ConfigFileType config) {
            this.file = Objects.requireNonNull(file, "file == null");
            this.identifier = Objects.requireNonNull(identifier, "identifier == null");
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt == null");
            this.config = Objects.requireNonNull(config, "config == null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigEntry that = (ConfigEntry)o;
            return this.file.equals(that.file) && this.identifier.equals(that.identifier) && this.updatedAt.equals(that.updatedAt) && this.config.equals(that.config);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.identifier, this.updatedAt, this.config);
        }

        public String toString() {
            return "ConfigEntry{file=" + this.file + ", identifier='" + this.identifier + "', updatedAt=" + this.updatedAt + ", config=" + this.config + "}";
        }
    }
}

