/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.morimekta.collect.util.Binary;
import net.morimekta.config.SecretListener;
import net.morimekta.config.SecretsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=SecretDeserializer.class)
public final class Secret {
    private final String name;
    private final boolean env;
    private final AtomicReference<Binary> reference;
    private final List<SecretListener> listeners;
    private static final Logger LOGGER = LoggerFactory.getLogger(Secret.class);

    public Secret(String name, boolean env, Binary value) {
        this.name = Objects.requireNonNull(name, "name == null");
        this.env = env;
        this.reference = new AtomicReference<Binary>(Objects.requireNonNull(value, "value == null"));
        this.listeners = new ArrayList<SecretListener>();
    }

    @JsonValue
    public String getName() {
        if (this.env) {
            return "${" + this.name + "}";
        }
        return this.name;
    }

    @JsonIgnore
    public String getAsString() {
        return this.reference.get().decodeToString(StandardCharsets.UTF_8);
    }

    @JsonIgnore
    public byte[] getAsBytes() {
        return this.reference.get().get();
    }

    @JsonIgnore
    public Binary getAsBinary() {
        return this.reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public void addListener(SecretListener listener) {
        List<SecretListener> list = this.listeners;
        synchronized (list) {
            this.listeners.removeIf(it -> it == listener);
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public void removeListener(SecretListener listener) {
        List<SecretListener> list = this.listeners;
        synchronized (list) {
            this.listeners.removeIf(it -> it == listener);
        }
    }

    @JsonIgnore
    public void setSecret(Binary secret) {
        Binary old = this.reference.getAndSet(Objects.requireNonNull(secret));
        if (secret.equals((Object)old)) {
            return;
        }
        Secret snapshot = new Secret(this.name, this.env, secret, this.listeners);
        for (SecretListener listener : this.getListeners()) {
            try {
                listener.onSecretChange(snapshot);
            }
            catch (Exception e) {
                LOGGER.warn("Exception notifying on secret update: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public String toString() {
        return "Secret{'" + this.getName() + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Secret secret = (Secret)o;
        return this.env == secret.env && this.name.equals(secret.name) && Objects.equals(this.reference.get(), secret.reference.get());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.env, this.reference.get());
    }

    private Secret(String name, boolean env, Binary value, List<SecretListener> listeners) {
        this.name = name;
        this.env = env;
        this.reference = new AtomicReference<Binary>(value);
        this.listeners = listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    private List<SecretListener> getListeners() {
        List<SecretListener> list = this.listeners;
        synchronized (list) {
            return List.copyOf(this.listeners);
        }
    }

    public static class SecretDeserializer
    extends JsonDeserializer<Secret> {
        public Secret deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.currentToken().id() == JsonToken.VALUE_STRING.id()) {
                String name = jsonParser.getValueAsString();
                SecretsManager manager = (SecretsManager)deserializationContext.getAttribute(SecretsManager.class);
                try {
                    if (name.startsWith("${") && name.endsWith("}")) {
                        String envName = name.substring(2, name.length() - 1);
                        if (manager != null && manager.exists(envName)) {
                            return manager.get(envName);
                        }
                        String value = System.getenv(envName);
                        if (value == null || value.isEmpty()) {
                            throw new JsonParseException(jsonParser, "Unknown secret " + name, jsonParser.currentTokenLocation());
                        }
                        return new Secret(envName, true, Binary.encodeFromString((String)value, (Charset)StandardCharsets.UTF_8));
                    }
                    if (manager == null) {
                        throw new JsonParseException(jsonParser, "No secrets manager to load secret: " + name, jsonParser.currentTokenLocation());
                    }
                    return manager.get(name);
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    throw new JsonParseException(jsonParser, e.getMessage(), jsonParser.currentTokenLocation(), (Throwable)e);
                }
                catch (NoSuchElementException e) {
                    throw new JsonParseException(jsonParser, "Unknown secret " + name, jsonParser.currentTokenLocation(), (Throwable)e);
                }
            }
            throw new JsonParseException(jsonParser, "Invalid Secret token " + jsonParser.getValueAsString() + ", expected string", jsonParser.currentTokenLocation());
        }
    }
}

