/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.morimekta.config.ConfigChangeListener;
import net.morimekta.config.ConfigChangeType;
import net.morimekta.config.ConfigEventListener;
import net.morimekta.config.ConfigException;
import net.morimekta.config.ConfigReader;
import net.morimekta.config.ConfigWatcher;
import net.morimekta.file.FileEvent;
import net.morimekta.file.FileEventListener;
import net.morimekta.file.FileUtil;
import net.morimekta.file.FileWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSupplier<ConfigType>
implements Supplier<ConfigType>,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigSupplier.class);
    private final Object mutex = new Object();
    private final AtomicReference<ConfigType> reference = new AtomicReference();
    private final ArrayList<ConfigChangeListener<ConfigType>> changeListeners = new ArrayList();
    private final ArrayList<ConfigEventListener> eventListeners = new ArrayList();
    private final ConfigReader<ConfigType> loader;
    private final Supplier<FileWatcher> fileWatcherSupplier;
    private final FileEventListener fileEventListener;

    public ConfigSupplier(ConfigReader<ConfigType> loader) {
        this(loader, ConfigWatcher.FILE_WATCHER);
    }

    public ConfigSupplier(ConfigReader<ConfigType> loader, Supplier<FileWatcher> fileWatcherSupplier) {
        this.loader = loader;
        this.fileWatcherSupplier = fileWatcherSupplier;
        this.fileEventListener = this::onFileEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigSupplier<ConfigType> addChangeListener(ConfigChangeListener<ConfigType> listener) {
        Object object = this.mutex;
        synchronized (object) {
            this.changeListeners.removeIf(it -> it == listener);
            this.changeListeners.add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigSupplier<ConfigType> addEventListener(ConfigEventListener listener) {
        Object object = this.mutex;
        synchronized (object) {
            this.eventListeners.removeIf(it -> it == listener);
            this.eventListeners.add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Path filePath) throws IOException, ConfigException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkBeforeLoad(filePath);
            this.reference.set(Objects.requireNonNull(this.loader.readConfig(filePath), "loaded config == null"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAndMonitor(Path filePath) throws ConfigException, IOException {
        Object object = this.mutex;
        synchronized (object) {
            ConfigType config;
            this.checkBeforeLoad(filePath);
            this.fileWatcherSupplier.get().weakAddWatcher(filePath, this.fileEventListener);
            try {
                config = Objects.requireNonNull(this.loader.readConfig(filePath), "loaded config == null");
                this.onConfigFileRead(FileEvent.CREATED, filePath, ConfigEventListener.Status.OK);
            }
            catch (ConfigException e) {
                this.onConfigFileRead(FileEvent.CREATED, filePath, ConfigEventListener.Status.PARSE_FAILED);
                throw e;
            }
            catch (IOException e) {
                this.onConfigFileRead(FileEvent.CREATED, filePath, ConfigEventListener.Status.READ_FAILED);
                throw e;
            }
            ConfigType old = this.reference.getAndSet(config);
            if (!config.equals(old)) {
                this.onConfigChange(ConfigChangeType.CREATED, filePath, config);
            }
        }
    }

    public void loadUnchecked(Path filePath) {
        try {
            this.load(filePath);
        }
        catch (ConfigException e) {
            throw e.asUncheckedException();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    public void loadAndMonitorUnchecked(Path filePath) {
        try {
            this.loadAndMonitor(filePath);
        }
        catch (ConfigException e) {
            throw e.asUncheckedException();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Override
    public ConfigType get() {
        return Optional.ofNullable(this.reference.get()).orElseThrow(() -> new NullPointerException("Config not loaded."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mutex;
        synchronized (object) {
            this.changeListeners.clear();
            this.eventListeners.clear();
            this.fileWatcherSupplier.get().removeWatcher(this.fileEventListener);
        }
    }

    public String toString() {
        return "ConfigSupplier{config=" + this.reference.get() + "}";
    }

    public static <ConfigType> ConfigSupplier<ConfigType> yamlConfig(Class<ConfigType> type) {
        return ConfigSupplier.yamlConfig(type, ObjectMapper::findAndRegisterModules);
    }

    public static <ConfigType> ConfigSupplier<ConfigType> yamlConfig(Class<ConfigType> type, Consumer<ObjectMapper> initMapper) {
        return new ConfigSupplier<ConfigType>(new ConfigReader.YamlConfigReader<ConfigType>(type, initMapper));
    }

    private void checkBeforeLoad(Path filePath) throws IOException {
        if (this.reference.get() != null) {
            throw new IllegalStateException("Config already loaded.");
        }
        Path canonical = FileUtil.readCanonicalPath((Path)filePath);
        if (!Files.exists(canonical, new LinkOption[0])) {
            throw new FileNotFoundException("No such config file " + filePath);
        }
        if (!Files.isRegularFile(canonical, new LinkOption[0])) {
            throw new IOException("Config path " + filePath + " is not a regular file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFileEvent(Path file, FileEvent event) {
        if (event == FileEvent.DELETED) {
            if (Files.exists(file, new LinkOption[0])) {
                return;
            }
            Object object = this.mutex;
            synchronized (object) {
                this.fileWatcherSupplier.get().removeWatcher(this.fileEventListener);
                this.onConfigFileRead(FileEvent.DELETED, file, ConfigEventListener.Status.OK);
                this.onConfigChange(ConfigChangeType.DELETED, file, this.reference.get());
            }
        }
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            ConfigType config;
            try {
                config = Objects.requireNonNull(this.loader.readConfig(file), "loaded config == null");
                this.onConfigFileRead(FileEvent.MODIFIED, file, ConfigEventListener.Status.OK);
            }
            catch (ConfigException e) {
                LOGGER.error("Exception parsing config: {}", (Object)e.getMessage(), (Object)e);
                this.onConfigFileRead(FileEvent.MODIFIED, file, ConfigEventListener.Status.PARSE_FAILED);
                return;
            }
            catch (IOException e) {
                LOGGER.error("Exception reading config: {}", (Object)e.getMessage(), (Object)e);
                this.onConfigFileRead(FileEvent.MODIFIED, file, ConfigEventListener.Status.READ_FAILED);
                return;
            }
            ConfigType old = this.reference.getAndSet(config);
            if (!config.equals(old)) {
                this.onConfigChange(ConfigChangeType.MODIFIED, file, config);
            }
        }
    }

    private void onConfigFileRead(FileEvent type, Path file, ConfigEventListener.Status status) {
        for (ConfigEventListener el : this.getEventListeners()) {
            try {
                el.onConfigFileRead(type, file, status);
            }
            catch (Exception e) {
                LOGGER.error("Exception notifying on config read.", (Throwable)e);
            }
        }
    }

    private void onConfigFileUpdate(ConfigChangeType type, Path file, ConfigEventListener.Status status) {
        for (ConfigEventListener el : this.getEventListeners()) {
            try {
                el.onConfigFileUpdate(type, file, file.getFileName().toString(), status);
            }
            catch (Exception e) {
                LOGGER.error("Exception notifying on config update.", (Throwable)e);
            }
        }
    }

    private void onConfigChange(ConfigChangeType type, Path file, ConfigType config) {
        boolean error = false;
        for (ConfigChangeListener<ConfigType> cl : this.getChangeListeners()) {
            try {
                cl.onConfigChange(type, config);
            }
            catch (Exception e) {
                error = true;
                LOGGER.error("Exception notifying updated config.", (Throwable)e);
            }
        }
        this.onConfigFileUpdate(type, file, error ? ConfigEventListener.Status.ERROR : ConfigEventListener.Status.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConfigChangeListener<ConfigType>> getChangeListeners() {
        Object object = this.mutex;
        synchronized (object) {
            return List.copyOf(this.changeListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConfigEventListener> getEventListeners() {
        Object object = this.mutex;
        synchronized (object) {
            return List.copyOf(this.eventListeners);
        }
    }
}

