/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.function.Consumer;
import net.morimekta.config.ConfigException;
import net.morimekta.file.FileUtil;

public abstract class ConfigReader<ConfigType> {
    protected ConfigReader() {
    }

    public ConfigType readConfig(Path file) throws IOException, ConfigException {
        Path canonical = FileUtil.readCanonicalPath((Path)Objects.requireNonNull(file, "file == null"));
        if (!Files.exists(canonical, new LinkOption[0])) {
            throw new FileNotFoundException("No such config file " + file);
        }
        if (!Files.isRegularFile(canonical, new LinkOption[0])) {
            throw new IOException("Config path " + file + " is not a regular file.");
        }
        try (InputStream in = Files.newInputStream(canonical, StandardOpenOption.READ);){
            ConfigType ConfigType = this.parseConfig(file, in);
            return ConfigType;
        }
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    protected ConfigType parseConfig(String fileName, InputStream stream) throws IOException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    protected ConfigType parseConfig(Path file, InputStream stream) throws IOException, ConfigException {
        return this.parseConfig(file.getFileName().toString(), stream);
    }

    public static final class YamlConfigReader<ConfigType>
    extends ConfigReader<ConfigType> {
        private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        private final Class<ConfigType> configType;

        public YamlConfigReader(Class<ConfigType> configType, Consumer<ObjectMapper> init) {
            this.configType = configType;
            init.accept(this.mapper);
        }

        @Override
        protected ConfigType parseConfig(Path file, InputStream stream) throws IOException, ConfigException {
            try {
                return (ConfigType)this.mapper.readValue(stream, this.configType);
            }
            catch (JsonParseException | JsonMappingException e) {
                throw ConfigException.asConfigException(e);
            }
        }
    }
}

