package net.morimekta.config;

import java.util.concurrent.atomic.AtomicReference;

import static net.morimekta.config.ConfigException.asConfigException;

/**
 * A small utility buffer class for accumulating exceptions and passing as
 * a config exception if any happens.
 */
public class ConfigExceptionBuffer {
    /**
     * Add exception to the buffer.
     *
     * @param e Exception to add.
     */
    public void update(Exception e) {
        ex.updateAndGet(old -> {
            if (old == null) {
                return asConfigException(e, 4);
            }
            old.addSuppressed(e);
            return old;
        });
    }

    /**
     * Throw the accumulated exception, if it has an exception.
     *
     * @throws ConfigException The accumulated exception if present.
     */
    public void throwIfPresent() throws ConfigException {
        if (ex.get() != null) {
            throw ex.get();
        }
    }

    // *****************
    // **   PRIVATE   **
    // *****************

    private final AtomicReference<ConfigException> ex = new AtomicReference<>();
}
