/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;

public class JsonLayout
extends LayoutBase<ILoggingEvent> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final TreeSet<String> stackTraceFilter = new TreeSet();
    private Format stackTraceFormat = Format.NORMAL;
    private boolean stackTraceIncludeShort = false;
    private ZoneId zoneId = ZoneId.systemDefault();
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxx");

    public void setZoneId(String zoneId) {
        try {
            this.zoneId = ZoneId.of(zoneId);
        }
        catch (Exception e) {
            this.zoneId = ZoneId.of("UTC");
        }
    }

    public void setStackTraceIncludeShort(String bool) {
        this.stackTraceIncludeShort = Boolean.parseBoolean(bool);
    }

    public void setStackTraceFormat(String format) {
        switch (format.strip().toLowerCase(Locale.US)) {
            case "full": {
                this.stackTraceFormat = Format.FULL;
                break;
            }
            case "short": {
                this.stackTraceFormat = Format.SHORT;
                this.stackTraceIncludeShort = false;
                break;
            }
            default: {
                this.stackTraceFormat = Format.NORMAL;
            }
        }
    }

    public void setStackTraceFilter(String filter) {
        this.stackTraceFilter.clear();
        for (String s : filter.split("\\s*,\\s*")) {
            this.stackTraceFilter.add(s.strip());
        }
    }

    public String doLayout(ILoggingEvent event) {
        if (!this.isStarted()) {
            return "";
        }
        Instant timestamp = Optional.ofNullable(event.getInstant()).orElseGet(() -> Instant.ofEpochMilli(event.getTimeStamp()));
        TreeMap<String, Object> entry = new TreeMap<String, Object>(event.getMDCPropertyMap());
        entry.put("@timestamp", this.formatTimestamp(timestamp));
        entry.put("message", event.getFormattedMessage());
        entry.put("level", event.getLevel().levelStr);
        entry.put("level_value", event.getLevel().levelInt);
        entry.put("logger_name", event.getLoggerName());
        entry.put("thread_name", event.getThreadName());
        if (event.getThrowableProxy() != null) {
            entry.put("stack_trace", this.formatStackTrace(event.getThrowableProxy()));
            if (this.stackTraceIncludeShort) {
                entry.put("stack_trace_short", this.formatStackTraceShort(event.getThrowableProxy()));
            }
        }
        try {
            return this.mapper.writeValueAsString(entry) + "\n";
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getContentType() {
        return "application/json";
    }

    private String formatTimestamp(Instant instant) {
        return TIMESTAMP_FORMATTER.format(instant.atZone(this.zoneId));
    }

    private String formatStackTrace(IThrowableProxy throwableProxy) {
        StringBuilder builder = new StringBuilder();
        this.formatStackTrace(this.stackTraceFormat, throwableProxy, builder);
        return builder.toString();
    }

    private String formatStackTraceShort(IThrowableProxy throwableProxy) {
        StringBuilder builder = new StringBuilder();
        this.formatStackTrace(Format.SHORT, throwableProxy, builder);
        return builder.toString();
    }

    private boolean skipStackTraceElement(int index, StackTraceElement element) {
        if (index == 0) {
            return false;
        }
        String id = element.getClassName() + "." + element.getMethodName();
        if (this.stackTraceFilter.contains(id)) {
            return true;
        }
        String lower = this.stackTraceFilter.lower(id);
        return lower != null && id.startsWith(lower);
    }

    private void formatStackTrace(Format stackTraceFormat, IThrowableProxy throwable, StringBuilder builder) {
        if (throwable.getCause() != null) {
            IThrowableProxy cause = throwable.getCause();
            this.formatStackTrace(stackTraceFormat, cause, builder);
            builder.append("Wrapped by: ");
        }
        builder.append(throwable.getClassName()).append(": ").append(throwable.getMessage()).append("\n");
        int skippedElements = 0;
        int printNumElements = stackTraceFormat == Format.SHORT ? 1 : Math.max(1, throwable.getStackTraceElementProxyArray().length - throwable.getCommonFrames());
        for (int i = 0; i < printNumElements; ++i) {
            StackTraceElementProxy elementProxy = throwable.getStackTraceElementProxyArray()[i];
            StackTraceElement element = elementProxy.getStackTraceElement();
            if (this.skipStackTraceElement(i, element)) {
                ++skippedElements;
                continue;
            }
            if (skippedElements > 0) {
                builder.append("\t[").append(skippedElements).append(" skipped]\n");
                skippedElements = 0;
            }
            builder.append("\tat ");
            if (stackTraceFormat == Format.FULL && element.getModuleName() != null) {
                builder.append(element.getModuleName());
                if (element.getModuleVersion() != null) {
                    builder.append("@").append(element.getModuleVersion());
                }
                builder.append("/");
            }
            builder.append(element.getClassName()).append(".").append(element.getMethodName()).append("(");
            if (element.isNativeMethod()) {
                builder.append("Native Method");
            } else {
                builder.append(element.getFileName()).append(":").append(element.getLineNumber());
            }
            builder.append(")\n");
        }
        if (skippedElements > 0) {
            builder.append("\t[").append(skippedElements).append(" skipped]\n");
        }
        if (stackTraceFormat != Format.SHORT && throwable.getCommonFrames() > 0) {
            builder.append("... ").append(throwable.getCommonFrames()).append(" common frames omitted\n");
        }
        for (IThrowableProxy suppressed : throwable.getSuppressed()) {
            builder.append("  ").append("Suppressed: ");
            this.formatStackTrace(stackTraceFormat, suppressed, builder);
        }
    }

    private static enum Format {
        FULL,
        NORMAL,
        SHORT;

    }
}

