/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.ConsoleAppender;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.morimekta.collect.UnmodifiableList;
import net.morimekta.terminal.args.Arg;
import net.morimekta.terminal.args.ArgException;
import net.morimekta.terminal.args.ArgHelp;
import net.morimekta.terminal.args.ArgParser;
import net.morimekta.terminal.args.Flag;
import net.morimekta.terminal.args.Option;
import net.morimekta.terminal.args.ValueParser;
import net.morimekta.tiny.server.TinyApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class TinyApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyApplication.class);
    private final String applicationName;
    private final AtomicReference<TinyApplicationContext> context;

    protected TinyApplication(String applicationName) {
        this.setUpUncaughtExceptionHandler();
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName == null");
        this.context = new AtomicReference();
    }

    protected void setUpUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> LOGGER.error("Uncaught exception in thread {}: {}", new Object[]{thread.getName(), throwable.getMessage(), throwable}));
    }

    protected abstract void initialize(ArgParser.Builder var1, TinyApplicationContext.Builder var2);

    protected abstract void onStart(TinyApplicationContext var1) throws Exception;

    protected void beforeStop(TinyApplicationContext context) throws Exception {
    }

    protected void afterStop(TinyApplicationContext context) throws Exception {
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return "latest";
    }

    public String getApplicationDescription() {
        return "A Tiny-Server Application";
    }

    public final void stop() {
        TinyApplicationContext context = this.context.getAndSet(null);
        if (context == null) {
            return;
        }
        context.setStopping();
        try {
            this.beforeStop(context);
        }
        catch (Exception e) {
            LOGGER.warn("Exception in beforeStop(): {}", (Object)e.getMessage(), (Object)e);
        }
        context.stopServer();
        try {
            this.afterStop(context);
        }
        catch (Exception e) {
            LOGGER.warn("Exception in afterStop(): {}", (Object)e.getMessage(), (Object)e);
        }
        ((LoggerContext)LoggerFactory.getILoggerFactory()).getLoggerList().stream().map(ch.qos.logback.classic.Logger::iteratorForAppenders).flatMap(it -> UnmodifiableList.asList((Iterator)it).stream()).filter(app -> app instanceof ConsoleAppender).map(app -> (ConsoleAppender)app).forEach(app -> {
            try {
                app.getOutputStream().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void startInternal(TinyApplicationContext context) throws Exception {
        try {
            this.onStart(context);
        }
        catch (Exception e) {
            LOGGER.error("Exception in onStarted(): {}", (Object)e.getMessage(), (Object)e);
            context.stopServer();
            throw e;
        }
        this.context.set(context);
        Thread stopServerThread = new Thread(this::stop);
        stopServerThread.setDaemon(false);
        stopServerThread.setName("TinyServerShutdownHook");
        Runtime.getRuntime().addShutdownHook(stopServerThread);
        context.setReady();
    }

    public static void start(TinyApplication app, String ... args) {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        java.util.logging.Logger.getLogger("").setLevel(Level.FINEST);
        ArgParser parser = null;
        try {
            ArgParser.Builder argParserBuilder = ArgParser.argParser((String)app.getApplicationName(), (String)app.getApplicationVersion(), (String)app.getApplicationDescription());
            AtomicBoolean help = new AtomicBoolean();
            argParserBuilder.add((Arg.Builder)Flag.flag((String)"--help", (String)"?h", (String)"Show help", help::set));
            TinyApplicationContext.Builder contextBuilder = new TinyApplicationContext.Builder(app);
            argParserBuilder.add((Arg.Builder)Option.optionLong((String)"--admin_host", (String)"Set IP address the admin server should listen to.", contextBuilder::setAdminHost).defaultValue((Object)"0.0.0.0").metaVar("IP"));
            argParserBuilder.add((Arg.Builder)Option.optionLong((String)"--admin_port", (String)"Set HTTP port the admin server should listen to.", (Consumer)ValueParser.i32(contextBuilder::setAdminPort)).defaultValue((Object)"0").metaVar("PORT"));
            argParserBuilder.add((Arg.Builder)Option.optionLong((String)"--admin_threads", (String)"Number of threads to use for admin server.", (Consumer)ValueParser.i32(contextBuilder::setAdminServerThreads)).defaultValue((Object)10).metaVar("THR"));
            app.initialize(argParserBuilder, contextBuilder);
            parser = argParserBuilder.parse(args);
            if (help.get()) {
                ArgHelp.argHelp((ArgParser)parser).printHelp(System.out);
                return;
            }
            parser.validate();
            app.startInternal(contextBuilder.build());
        }
        catch (ArgException e) {
            if (e.getParser() != null) {
                ArgHelp.argHelp((ArgParser)e.getParser()).usageWidth(80).printPreamble(System.err);
                System.err.println();
                System.err.println(e.getMessage());
            }
            if (parser != null) {
                ArgHelp.argHelp(parser).usageWidth(80).printPreamble(System.err);
                System.err.println();
                System.err.println(e.getMessage());
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

