package net.morimekta.tiny.server.http;

import java.util.HashMap;
import java.util.Map;

import static java.net.URLDecoder.decode;
import static java.nio.charset.StandardCharsets.UTF_8;

public final class TinyHttpUtil {
    /**
     * Very simple URL query parser.
     *
     * @param query The query string.
     * @return Map of query argument to value.
     */
    public static Map<String, String> parseQuery(String query) {
        if (query == null) {
            return Map.of();
        }
        if (query.isEmpty()) {
            return Map.of();
        }
        var queryMap = new HashMap<String, String>();
        for (String part : query.split("&")) {
            if (part.isEmpty()) {
                continue;
            }
            String[] kv = part.split("=", 2);
            if (kv[0].isEmpty()) {
                // Ignore argument?
                continue;
            }
            if (kv.length == 2) {
                queryMap.put(decode(kv[0], UTF_8), decode(kv[1], UTF_8));
            } else {
                queryMap.put(decode(kv[0], UTF_8), "");
            }
        }
        return Map.copyOf(queryMap);
    }

    // ------ PRIVATE ------
    private TinyHttpUtil() {}
}
