/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.morimekta.collect.util.SetOperations;
import net.morimekta.tiny.server.TinyApplication;
import net.morimekta.tiny.server.http.TinyHealth;
import net.morimekta.tiny.server.http.TinyHealthHttpHandler;
import net.morimekta.tiny.server.http.TinyHttpHandler;
import net.morimekta.tiny.server.http.TinyReadyHttpHandler;

public final class TinyApplicationContext {
    static final String SERVER_READINESS = "tiny-server";
    private final int localPort;
    private final HttpServer httpServer;
    private final Map<String, TinyHealth.ReadyCheck> readyCheckMap;
    private final Map<String, TinyHealth.HealthCheck> healthCheckMap;

    private TinyApplicationContext(HttpServer httpServer, Map<String, TinyHealth.ReadyCheck> readyCheckMap, Map<String, TinyHealth.HealthCheck> healthCheckMap) {
        this.httpServer = httpServer;
        this.localPort = httpServer.getAddress().getPort();
        this.readyCheckMap = readyCheckMap;
        this.healthCheckMap = healthCheckMap;
    }

    public int getAdminPort() {
        return this.localPort;
    }

    public TinyApplicationContext addReadyCheck(String name, TinyHealth.ReadyCheck readyCheck) {
        if (this.readyCheckMap.containsKey(name)) {
            throw new IllegalArgumentException("Readiness check with name \"" + name + "\" already exists.");
        }
        this.readyCheckMap.put(name, readyCheck);
        return this;
    }

    public TinyApplicationContext removeReadyCheck(String name) {
        this.readyCheckMap.remove(name);
        return this;
    }

    public TinyApplicationContext addHealthCheck(String name, TinyHealth.HealthCheck healthCheck) {
        if (this.healthCheckMap.containsKey(name)) {
            throw new IllegalArgumentException("Health check with name \"" + name + "\" already exists.");
        }
        this.healthCheckMap.put(name, healthCheck);
        return this;
    }

    public TinyApplicationContext removeHealthCheck(String name) {
        this.healthCheckMap.remove(name);
        return this;
    }

    void stopServer() {
        this.httpServer.stop(0);
    }

    void setReady() {
        this.removeReadyCheck(SERVER_READINESS);
    }

    void setStopping() {
        this.removeReadyCheck(SERVER_READINESS);
        this.addReadyCheck(SERVER_READINESS, () -> TinyHealth.unhealthy("Server is stopping."));
    }

    public static final class Builder {
        private final TinyApplication server;
        private int adminPort = 0;
        private String adminHost = "0.0.0.0";
        private int threads = 10;
        private String readyPath = "/ready";
        private String healthyPath = "/healthy";
        private String drainPath = "/drain";
        private final HttpServer httpServer;
        private final Set<String> httpContextSet;

        public Builder(TinyApplication server) throws IOException {
            this.server = server;
            this.httpContextSet = new HashSet<String>();
            this.httpServer = HttpServer.create();
        }

        public void setReadyPath(String readyPath) {
            Set knownContexts = SetOperations.union((Set[])new Set[]{this.httpContextSet, Set.of(this.healthyPath, this.drainPath)});
            if (knownContexts.contains(readyPath)) {
                throw new IllegalArgumentException("Context " + readyPath + " already exists.");
            }
            this.readyPath = readyPath;
        }

        public void setHealthyPath(String healthyPath) {
            Set knownContexts = SetOperations.union((Set[])new Set[]{this.httpContextSet, Set.of(this.readyPath, this.drainPath)});
            if (knownContexts.contains(healthyPath)) {
                throw new IllegalArgumentException("Context " + healthyPath + " already exists.");
            }
            this.healthyPath = healthyPath;
        }

        public void setDrainPath(String drainPath) {
            Set knownContexts = SetOperations.union((Set[])new Set[]{this.httpContextSet, Set.of(this.readyPath, this.healthyPath)});
            if (knownContexts.contains(drainPath)) {
                throw new IllegalArgumentException("Context " + drainPath + " already exists.");
            }
            this.drainPath = drainPath;
        }

        public void addHttpHandler(String context, HttpHandler handler) {
            Objects.requireNonNull(context, "context == null");
            Objects.requireNonNull(handler, "handler == null");
            Set knownContexts = SetOperations.union((Set[])new Set[]{this.httpContextSet, Set.of(this.readyPath, this.healthyPath, this.drainPath)});
            if (knownContexts.contains(context)) {
                throw new IllegalArgumentException("Context " + context + " already exists.");
            }
            this.httpServer.createContext(context, handler);
            this.httpContextSet.add(context);
        }

        void setAdminPort(int localPort) {
            this.adminPort = localPort;
        }

        void setAdminHost(String localHost) {
            this.adminHost = localHost;
        }

        void setAdminServerThreads(int threads) {
            this.threads = threads;
        }

        TinyApplicationContext build() throws IOException {
            ConcurrentHashMap<String, TinyHealth.HealthCheck> healthChecks = new ConcurrentHashMap<String, TinyHealth.HealthCheck>();
            ConcurrentHashMap<String, TinyHealth.ReadyCheck> readyChecks = new ConcurrentHashMap<String, TinyHealth.ReadyCheck>();
            readyChecks.put(TinyApplicationContext.SERVER_READINESS, () -> TinyHealth.unhealthy("Server is starting."));
            this.httpServer.setExecutor(Executors.newFixedThreadPool(this.threads, new ThreadFactory(){
                final AtomicInteger nextId = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setName("TinyHttpServer-" + this.nextId.getAndIncrement());
                    thread.setDaemon(true);
                    return thread;
                }
            }));
            this.httpServer.createContext(this.readyPath, new TinyReadyHttpHandler(readyChecks));
            this.httpServer.createContext(this.healthyPath, new TinyHealthHttpHandler(healthChecks));
            this.httpServer.createContext(this.drainPath, new TinyHttpHandler(){

                @Override
                protected void doGet(HttpExchange exchange) throws IOException {
                    Thread thread = new Thread(server::stop);
                    thread.setName("TinyServerDrain");
                    thread.setDaemon(false);
                    thread.start();
                    exchange.sendResponseHeaders(204, -1L);
                }
            });
            this.httpServer.bind(new InetSocketAddress(this.adminHost, this.adminPort), 100);
            this.httpServer.start();
            return new TinyApplicationContext(this.httpServer, readyChecks, healthChecks);
        }
    }
}

