/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server.secrets;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.morimekta.collect.util.Binary;
import net.morimekta.file.DirWatcher;
import net.morimekta.file.FileEvent;
import net.morimekta.file.FileEventListener;
import net.morimekta.file.FileUtil;
import net.morimekta.file.FileWatcher;
import net.morimekta.tiny.server.secrets.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=SecretManagerDeserializer.class)
public class SecretsManager {
    private final Map<String, AtomicReference<Binary>> references = new ConcurrentHashMap<String, AtomicReference<Binary>>();
    private final Map<String, Secret> secrets = new ConcurrentHashMap<String, Secret>();
    private final Path dir;
    private final FileWatcher fileWatcher;
    private final FileEventListener listener;
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretsManager.class);

    public SecretsManager(Path dir) {
        this.dir = Objects.requireNonNull(dir, "dir == null");
        this.fileWatcher = new FileWatcher(new DirWatcher());
        this.listener = this::onFileEvent;
    }

    @JsonValue
    public Path getSecretsPath() {
        return this.dir;
    }

    @JsonIgnore
    public boolean exists(String name) {
        try {
            Path path = this.dir.resolve(name);
            Path canonical = FileUtil.readCanonicalPath((Path)path);
            return Files.isRegularFile(canonical, new LinkOption[0]);
        }
        catch (IOException e) {
            return false;
        }
    }

    @JsonIgnore
    public String getAsString(String name) {
        return this.get(name).getAsString();
    }

    @JsonIgnore
    public byte[] getAsBytes(String name) {
        return this.get(name).getAsBytes();
    }

    @JsonIgnore
    public Binary getAsBinary(String name) {
        return this.get(name).getAsBinary();
    }

    @JsonIgnore
    public Secret get(String name) {
        Objects.requireNonNull(name, "name == null");
        if (name.isBlank()) {
            throw new IllegalArgumentException("Empty secret name.");
        }
        if (name.startsWith(".") || name.contains(File.separator)) {
            throw new IllegalArgumentException("Hidden file or path in name, not allowed: \"" + name + "\"");
        }
        Path path = this.dir.resolve(name);
        return this.secrets.computeIfAbsent(name, k -> {
            this.fileWatcher.addWatcher(path, this.listener);
            return new Secret(name, false, this.references.computeIfAbsent(name, n -> {
                AtomicReference<Binary> ref = new AtomicReference<Binary>();
                ref.set(SecretsManager.readSecret(name, path));
                return ref;
            }));
        });
    }

    private void onFileEvent(Path file, FileEvent event) {
        String name = file.getFileName().toString();
        if (event == FileEvent.DELETED) {
            this.references.remove(name);
            this.secrets.remove(name);
            this.fileWatcher.removeWatcher(file, this.listener);
            return;
        }
        try {
            this.references.computeIfAbsent(name, n -> new AtomicReference()).set(SecretsManager.readSecret(name, file));
        }
        catch (NoSuchElementException e) {
            this.fileWatcher.removeWatcher(file, this.listener);
        }
    }

    private static Binary readSecret(String name, Path file) {
        Binary binary;
        block8: {
            Path canonical = FileUtil.readCanonicalPath((Path)file);
            InputStream in = Files.newInputStream(canonical, new OpenOption[0]);
            try {
                binary = Binary.read((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Unable to read secret {}: {}", new Object[]{file, e.getMessage(), e});
                    throw new NoSuchElementException("No secret for " + name);
                }
            }
            in.close();
        }
        return binary;
    }

    private static boolean isTokenType(JsonToken token, JsonToken type) {
        return token.id() == type.id();
    }

    public static class SecretsConfig {
        @JsonProperty(required=true)
        public Path dir;
    }

    public static class SecretManagerDeserializer
    extends JsonDeserializer<SecretsManager> {
        public SecretsManager deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (SecretsManager.isTokenType(jsonParser.currentToken(), JsonToken.VALUE_STRING)) {
                try {
                    Path path = Paths.get(jsonParser.getValueAsString(), new String[0]);
                    Path canonical = FileUtil.readCanonicalPath((Path)path);
                    SecretsManager manager = new SecretsManager(canonical);
                    deserializationContext.setAttribute(SecretsManager.class, (Object)manager);
                    return manager;
                }
                catch (IOException e) {
                    throw new JsonParseException(jsonParser, "Invalid Secrets directory " + jsonParser.currentToken(), (Throwable)e);
                }
            }
            if (SecretsManager.isTokenType(jsonParser.currentToken(), JsonToken.START_OBJECT)) {
                try {
                    SecretsConfig config = (SecretsConfig)jsonParser.readValueAs(SecretsConfig.class);
                    Path canonical = FileUtil.readCanonicalPath((Path)config.dir);
                    SecretsManager manager = new SecretsManager(canonical);
                    deserializationContext.setAttribute(SecretsManager.class, (Object)manager);
                    return manager;
                }
                catch (IOException e) {
                    throw new JsonParseException(jsonParser, "Invalid Secrets directory " + jsonParser.currentToken(), (Throwable)e);
                }
            }
            throw new JsonParseException(jsonParser, "Invalid SecretManager path value " + jsonParser.currentToken());
        }
    }
}

