/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server.secrets;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import net.morimekta.collect.util.Binary;
import net.morimekta.tiny.server.secrets.SecretsManager;

@JsonDeserialize(using=SecretDeserializer.class)
public class Secret {
    private final String name;
    private final boolean env;
    private final AtomicReference<Binary> reference;

    public Secret(String name, boolean env, AtomicReference<Binary> reference) {
        this.name = name;
        this.env = env;
        this.reference = reference;
    }

    @JsonProperty
    public String getName() {
        if (this.env) {
            return "${" + this.name + "}";
        }
        return this.name;
    }

    @JsonIgnore
    public String getAsString() {
        return this.reference.get().decodeToString(StandardCharsets.UTF_8);
    }

    @JsonIgnore
    public byte[] getAsBytes() {
        return this.reference.get().get();
    }

    @JsonIgnore
    public Binary getAsBinary() {
        return this.reference.get();
    }

    public static class SecretDeserializer
    extends JsonDeserializer<Secret> {
        public Secret deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.currentToken().id() == JsonToken.VALUE_STRING.id()) {
                String name = jsonParser.getValueAsString();
                SecretsManager manager = (SecretsManager)deserializationContext.getAttribute(SecretsManager.class);
                try {
                    if (name.startsWith("${") && name.endsWith("}")) {
                        String envName = name.substring(2, name.length() - 1);
                        if (manager != null && manager.exists(envName)) {
                            return manager.get(envName);
                        }
                        String value = System.getenv(envName);
                        if (value == null || value.isEmpty()) {
                            throw new JsonParseException(jsonParser, "Unknown secret " + name);
                        }
                        return new Secret(name, true, new AtomicReference<Binary>(Binary.encodeFromString((String)value, (Charset)StandardCharsets.UTF_8)));
                    }
                    if (manager == null) {
                        throw new JsonParseException(jsonParser, "No secrets manager to load: " + name);
                    }
                    if (manager.exists(name)) {
                        return manager.get(name);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new JsonParseException(jsonParser, e.getMessage(), (Throwable)e);
                }
                catch (NoSuchElementException e) {
                    throw new JsonParseException(jsonParser, "Unknown secret " + name);
                }
                throw new JsonParseException(jsonParser, "Unknown secret " + name);
            }
            throw new JsonParseException(jsonParser, "Invalid Secret token " + jsonParser.currentToken());
        }
    }
}

