/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.tiny.server.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.morimekta.tiny.server.http.TinyHealth;
import net.morimekta.tiny.server.http.TinyHealthHttpHandler;
import net.morimekta.tiny.server.http.TinyHttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TinyReadyHttpHandler
extends TinyHttpHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyReadyHttpHandler.class);
    private final Map<String, TinyHealth.ReadyCheck> readyChecks;

    public TinyReadyHttpHandler(Map<String, TinyHealth.ReadyCheck> readyChecks) {
        this.readyChecks = readyChecks;
    }

    @Override
    protected void doGet(HttpExchange exchange) throws IOException {
        TreeMap out = new TreeMap();
        AtomicInteger status = new AtomicInteger(200);
        this.readyChecks.forEach((name, check) -> {
            try {
                TinyHealth.Result result = check.readyCheck();
                if (result.getStatus() != TinyHealth.Status.OK) {
                    LOGGER.warn("Non OK result: {}", (Object)result);
                    status.set(500);
                }
                out.put(name, result);
            }
            catch (Exception e) {
                LOGGER.warn("Exception in readyCheck(): {}", (Object)e.getMessage(), (Object)e);
                out.put(name, new TinyHealth.Result(TinyHealth.Status.ERROR, String.valueOf(e.getMessage())));
                status.set(500);
            }
        });
        byte[] data = TinyHealthHttpHandler.MAPPER.writeValueAsBytes(out);
        exchange.getResponseHeaders().set("Content-Type", "application/json");
        exchange.sendResponseHeaders(status.get(), data.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(data);
        }
    }
}

